/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.model;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.commons.CommonUtils;
import com.centreon.studio.client.model.decoration.object.ObjectDecorator;
import com.centreon.studio.client.model.decoration.repository.ARepositoryStrategy;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.preference.model.PreferenceRepositoryDecorator;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;

@Creatable
@Singleton
public class PreferenceApplierRepositoryStrategy
extends ARepositoryStrategy {
    private final PreferenceRepositoryDecorator repository;
    private ACLUser user;

    private static <T> T getScopedProperty(INode scope, IObject target, PropertyDescriptor<T> property) {
        INode scopedTarget = INodeUtils.findNode((INode)scope, (TypeDescriptor)target.getType(), (Long)target.getId(), (PropertyValue[])new PropertyValue[0]);
        if (scopedTarget != null && !PreferenceApplierRepositoryStrategy.isDefaultValue((IObject)scopedTarget, property)) {
            return (T)scopedTarget.getProperty(property);
        }
        INode scopedTargetType = INodeUtils.findNode((INode)scope, (TypeDescriptor)target.getType(), (Long)target.getId(), (PropertyValue[])new PropertyValue[0]);
        if (scopedTargetType != null && !PreferenceApplierRepositoryStrategy.isDefaultValue((IObject)scopedTargetType, property)) {
            return (T)scopedTargetType.getProperty(property);
        }
        if (!PreferenceApplierRepositoryStrategy.isDefaultValue((IObject)scope, property)) {
            return (T)scope.getProperty(property);
        }
        return null;
    }

    private static boolean isDefaultValue(IObject object, PropertyDescriptor<?> property) {
        Object value = ((IObject)object.adapt(IObject.class)).getProperty(property);
        if (Objects.equals(value, property.defaulValue)) {
            return true;
        }
        for (PropertyValue defaultValues : object.getDefaultPropertyValues()) {
            if (!defaultValues.getProperty().equals(property)) continue;
            return value.equals(defaultValues.getValue());
        }
        return false;
    }

    @Inject
    public PreferenceApplierRepositoryStrategy(PreferenceRepositoryDecorator repository) {
        this.repository = repository;
    }

    public <T> T getProperty(ObjectDecorator decorator, PropertyDescriptor<T> property) {
        T value;
        T value2;
        INode node = (INode)decorator.adapt(INode.class);
        if (node == null) {
            return null;
        }
        if (!PreferenceApplierRepositoryStrategy.isDefaultValue((IObject)node, property)) {
            return (T)node.getProperty(property);
        }
        INode scope = CommonUtils.getScope((INode)node);
        INode objectScope = INodeUtils.findNode((INode)this.repository, (TypeDescriptor)scope.getType(), (Long)scope.getId(), (PropertyValue[])new PropertyValue[0]);
        if (objectScope != null && (value2 = PreferenceApplierRepositoryStrategy.getScopedProperty(objectScope, (IObject)decorator, property)) != null) {
            return value2;
        }
        INode userScope = INodeUtils.findNode((INode)this.repository, (TypeDescriptor)this.user.getType(), (Long)this.user.getId(), (PropertyValue[])new PropertyValue[0]);
        if (userScope != null && (value = PreferenceApplierRepositoryStrategy.getScopedProperty(userScope, (IObject)decorator, property)) != null) {
            return value;
        }
        return null;
    }

    @Inject
    public void setUser(@Optional ACLUser user) {
        this.user = user;
    }
}

