/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.model;

import com.centreon.studio.client.commons.CommonUtils;
import com.centreon.studio.client.model.decoration.node.NodeDecorator;
import com.centreon.studio.client.model.decoration.repository.ARepositoryStrategy;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.preference.model.PreferenceWebService;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PreferenceRepositoryStrategy
extends ARepositoryStrategy {
    private final PreferenceWebService service;

    @Inject
    public PreferenceRepositoryStrategy(PreferenceWebService service) {
        this.service = service;
    }

    public void relationsAdded(NodeDecorator decorator, Collection<INodeRelation> relations) {
        HashSet<IObject> scopes = new HashSet<IObject>();
        for (INodeRelation relation : relations) {
            INode scope = CommonUtils.getScope((INode)relation.getTarget());
            scopes.add((IObject)scope);
        }
        this.service.loadScopes(scopes);
    }

    public void relationsRemoved(NodeDecorator decorator, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            INode scope = CommonUtils.getScope((INode)relation.getTarget());
            INodeRelation preferenceRelation = INodeUtils.findRelationForTarget((INode)scope, (TypeDescriptor)relation.getTarget().getType(), (Long)relation.getTarget().getId(), (PropertyValue[])new PropertyValue[0]);
            if (preferenceRelation == null) continue;
            preferenceRelation.getSource().removeRelation(preferenceRelation);
        }
    }
}

