/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.model;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.PropertiesMapper;
import com.centreon.studio.client.cxf.AWebService;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.preference.model.PreferenceRepository;
import com.centreon.studio.client.utils.StepTimeTracker;
import com.centreon.studio.map.preference.ScopeDto;
import com.centreon.studio.map.preferenceservice.PreferencePortType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PreferenceWebService
extends AWebService<PreferencePortType> {
    private final BrokerEventManager eventManager;
    private final PreferenceRepository repository;

    private static INode dtoToScope(ScopeDto dto, IRepository repository, PropertyValue value) {
        TypeDescriptor type = TypeDescriptor.getType((Integer)dto.getTargetType());
        Collection propertyValues = PropertiesMapper.dtoToProperties((List)dto.getPreferences(), (PropertyValue[])new PropertyValue[]{value});
        INode scope = NodeFactories.INSTANCE.create(type, Long.valueOf(dto.getTargetId()), propertyValues, repository);
        List dtoChildren = dto.getChildren();
        ArrayList<INodeRelation> children = new ArrayList<INodeRelation>();
        for (ScopeDto child : dtoChildren) {
            INode childScope = PreferenceWebService.dtoToScope(child, repository, value);
            children.add(NodeRelationFactories.INSTANCE.create(scope, childScope));
        }
        scope.addRelations(children);
        return scope;
    }

    private static ScopeDto scopeToDto(INode scope) {
        ScopeDto dto = new ScopeDto();
        dto.setTargetId(scope.getId().longValue());
        dto.setTargetType(scope.getType().getId().intValue());
        dto.getPreferences().addAll(PropertiesMapper.propertiesToDtos((Collection)scope.getPropertyValues()));
        for (INodeRelation relation : scope.getRelations(new TypeDescriptor[0])) {
            dto.getChildren().add(PreferenceWebService.scopeToDto(relation.getTarget()));
        }
        return dto;
    }

    @Inject
    public PreferenceWebService(BrokerEventManager eventManager, PreferenceRepository repository) {
        super("/centreon-studio/services/preference?wsdl", PreferencePortType.class, !Configuration.SKIP_GZIP);
        this.eventManager = eventManager;
        this.repository = repository;
    }

    public void loadScopes(Collection<IObject> identifiers) {
        if (!this.isInit()) {
            return;
        }
        StepTimeTracker counter = new StepTimeTracker("PreferenceWebService.loadScopes() " + identifiers.size());
        ArrayList relationsToAdd = new ArrayList(identifiers.size());
        for (IObject identifier : identifiers) {
            try {
                ScopeDto dto;
                INode existingScope = INodeUtils.findNode((INode)this.repository, (TypeDescriptor)identifier.getType(), (Long)identifier.getId(), (PropertyValue[])new PropertyValue[0]);
                if (existingScope == null) {
                    existingScope = NodeFactories.INSTANCE.create(identifier.getType(), identifier.getId(), null, (IRepository)this.repository);
                    existingScope.addPropertyValue(PropertyDescriptors.SCOPE, (Object)existingScope);
                    INodeRelation currentRelation = NodeRelationFactories.INSTANCE.create((INode)this.repository, existingScope);
                    this.repository.addRelations(Arrays.asList(currentRelation));
                }
                if ((dto = ((PreferencePortType)this.service).getPreference(identifier.getType().getId().intValue(), identifier.getId().longValue())) == null) continue;
                PropertyValue value = new PropertyValue(PropertyDescriptors.SCOPE, (Object)existingScope);
                INode remoteScope = PreferenceWebService.dtoToScope(dto, (IRepository)this.repository, value);
                remoteScope.addPropertyValues(Arrays.asList(value));
                INodeUtils.performDelta((INode)existingScope, (INode)remoteScope, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
            }
            catch (Exception e) {
                this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            }
        }
        this.repository.addRelations(relationsToAdd);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)counter.finish(), (Object[])new Object[0]));
    }

    public boolean saveScope(INode scope) {
        if (!this.isInit()) {
            return false;
        }
        StepTimeTracker counter = new StepTimeTracker("PreferenceWebService.saveScope() " + scope + " " + scope.getPropertyValues());
        try {
            ScopeDto dto = PreferenceWebService.scopeToDto(scope);
            if (dto != null && !dto.getPreferences().isEmpty()) {
                ((PreferencePortType)this.service).setPreference(dto);
                return true;
            }
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
        finally {
            this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)counter.finish(), (Object[])new Object[0]));
        }
        return false;
    }
}

