/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.log;

import ch.qos.logback.core.rolling.RollingFileAppender;
import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.log.LogEventHandler;
import java.io.File;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public final class LogAddon
extends LogEventHandler {
    public static final File LOG_HOME = new File(Configuration.APPLI_HOME, "logs");

    static {
        Assert.isTrue((LOG_HOME.exists() || LOG_HOME.mkdirs() ? 1 : 0) != 0, (String)"ERROR : !LogAddon.LOG_HOME.exists() && !LogAddon.LOG_HOME.mkdirs()");
    }

    @Inject
    public LogAddon() {
        File newFile = new File(LOG_HOME, "Centreon-Map4.log");
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        RollingFileAppender appender = (RollingFileAppender)logger.getAppender("FILE");
        appender.stop();
        File oldFile = new File(appender.getFile());
        appender.setFile(newFile.getAbsolutePath());
        appender.start();
        oldFile.delete();
    }

    public void handleEvent(LogEvent event) {
        Logger logger = LoggerFactory.getLogger((Class)event.getLoggerClass());
        if (event.getThrowable() != null) {
            logger.error(event.getMessage(), event.getThrowable());
            return;
        }
        if (!LogEvent.LOG_LEVEL.shouldLog(event.getLogLevel())) {
            return;
        }
        switch (event.getLogLevel()) {
            case TRACE: {
                logger.trace(event.getMessage(), event.getArgs());
                break;
            }
            case DEBUG: {
                logger.debug(event.getMessage(), event.getArgs());
                break;
            }
            default: {
                logger.info(event.getMessage(), event.getArgs());
                break;
            }
            case WARNING: {
                logger.warn(event.getMessage(), event.getArgs());
                break;
            }
            case ERROR: {
                logger.error(event.getMessage(), event.getArgs());
            }
        }
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager) {
        eventManager.subscribe("studio/logs", true, (StudioEventHandler)this);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Log addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    protected void preDestroy(BrokerEventManager eventManager) {
        eventManager.unsubscribe((StudioEventHandler)this);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Log addon destroyed", (Object[])new Object[0]));
    }
}

