/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.model;

import com.centreon.studio.map.client.elements.widgets.messages.WidgetMessages;

public enum Orientation {
    BOTTOM_TO_TOP(1L, WidgetMessages.bottomToTop, true, false),
    LEFT_TO_RIGHT(2L, WidgetMessages.leftToRight, false, false),
    TOP_TO_BOTTOM(3L, WidgetMessages.topToBottom, true, true),
    RIGHT_TO_LEFT(4L, WidgetMessages.rightToLeft, false, true);

    private final String label;
    private final Long id;
    private final boolean isReversed;
    private final boolean isVertical;

    public static Orientation fromLabel(String label) {
        Orientation orientationFromLabel = null;
        if (label.equals(Orientation.BOTTOM_TO_TOP.label)) {
            orientationFromLabel = BOTTOM_TO_TOP;
        } else if (label.equals(Orientation.LEFT_TO_RIGHT.label)) {
            orientationFromLabel = LEFT_TO_RIGHT;
        } else if (label.equals(Orientation.TOP_TO_BOTTOM.label)) {
            orientationFromLabel = TOP_TO_BOTTOM;
        } else if (label.equals(Orientation.RIGHT_TO_LEFT.label)) {
            orientationFromLabel = RIGHT_TO_LEFT;
        }
        return orientationFromLabel;
    }

    private Orientation(Long id, String label, boolean isVertical, boolean isReversed) {
        this.id = id;
        this.label = label;
        this.isVertical = isVertical;
        this.isReversed = isReversed;
    }

    public Long getId() {
        return this.id;
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public String toString() {
        return this.label;
    }
}

