/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.gef.figures;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.gef.figures.NodeFigure;
import com.centreon.studio.client.utils.StringUtils;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ChartFigure
extends NodeFigure
implements ICallBackNotifier {
    private static final float CHART_REDUCTION_RATIO = 0.1f;
    private final Label label;
    private final ImageFigure imageFigure;
    private Chart chart;
    private IDeviceRenderer renderer;
    private GeneratedChartState chartState;
    private boolean needsGeneration;

    public ChartFigure(Chart chart) {
        this.setAlpha(50);
        this.chart = chart;
        this.imageFigure = new ImageFigure();
        this.add((IFigure)this.imageFigure);
        this.label = new Label();
        this.add((IFigure)this.label);
        try {
            this.renderer = PluginSettings.instance().getDevice("dv.SWT");
            if (this.renderer != null) {
                this.renderer.setProperty("device.component", (Object)this);
            }
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
    }

    public void callback(Object event, Object source, CallBackValue value) {
        if (this.chart instanceof ICallBackNotifier) {
            ((ICallBackNotifier)this.chart).callback(event, source, value);
        }
    }

    public Chart getChart() {
        return this.chart;
    }

    public Chart getDesignTimeModel() {
        return null;
    }

    public Chart getRunTimeModel() {
        return this.chartState.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.needsGeneration = true;
        this.repaintChart();
    }

    public void repaintChart() {
        if (this.getChart() == null || this.getChart().getStyles() == null || this.renderer == null) {
            return;
        }
        Rectangle rect = this.imageFigure.getBounds();
        org.eclipse.swt.graphics.Rectangle swtRect = new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
        if (swtRect.width > 0 && swtRect.height > 0) {
            Image chartImage = new Image((Device)Display.getCurrent(), swtRect);
            GC gc = new GC((Drawable)chartImage);
            this.renderer.setProperty("device.output.context", (Object)gc);
            int widthReduction = (int)((float)rect.width * 0.1f);
            int heightReduction = (int)((float)rect.height * 0.1f);
            Bounds bounds = BoundsImpl.create((double)(widthReduction / 2), (double)(heightReduction / 2), (double)(rect.width - widthReduction), (double)(rect.height - heightReduction));
            bounds.scale(72.0 / (double)this.renderer.getDisplayServer().getDpiResolution());
            Generator generator = Generator.instance();
            try {
                try {
                    if (this.needsGeneration) {
                        this.chartState = generator.build(this.renderer.getDisplayServer(), this.chart, bounds, null, null, null);
                        this.needsGeneration = false;
                    }
                    generator.render(this.renderer, this.chartState);
                    chartImage = SWTUtils.transparentImage((Image)chartImage, (RGB)new RGB(255, 255, 255), (boolean)true);
                    Image formerImage = this.imageFigure.getImage();
                    if (formerImage != null && !formerImage.isDisposed()) {
                        formerImage.dispose();
                    }
                    this.imageFigure.setImage(chartImage);
                }
                catch (ChartException ce) {
                    ce.printStackTrace();
                    gc.dispose();
                }
            }
            finally {
                gc.dispose();
            }
        }
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        int w = this.bounds.width;
        int h = this.bounds.height;
        Rectangle currentBounds = new Rectangle(0, 0, w, h);
        this.imageFigure.setBounds(currentBounds);
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public void setForegroundColor(Color fg) {
        this.label.setForegroundColor(fg);
    }

    public void setLabel(String label) {
        if (StringUtils.isNullEmptyOrBlank((String)label)) {
            this.label.setSize(0, 0);
        } else {
            this.label.setText(label);
            this.label.setSize(this.bounds.width, 20);
            this.label.setLocation(new Point(0, this.bounds.height - 20));
        }
    }
}

