/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.gef.figures;

import com.centreon.studio.client.gef.figures.NodeFigure;
import com.centreon.studio.map.client.elements.widgets.model.Orientation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class GaugeFigure
extends NodeFigure {
    private static final String FORMAT_1_DIGITS = "%.1f";
    private static final String FORMAT_INTEGER = "%.0f";
    private static final int LABEL_HEIGHT = 25;
    private static final int LABEL_WIDTH = 70;
    private final RoundedRectangle fullGauge;
    private final RoundedRectangle coloredGauge;
    private final Label labelLabel;
    private final Label minLabel;
    private final Label maxLabel;
    private final Label valueLabel;
    private Orientation orientation = Orientation.BOTTOM_TO_TOP;
    private double factor;

    private static final int getMinHeight(Orientation orientation) {
        return orientation.isVertical() ? 100 : 25;
    }

    private static final int getMinWidth(Orientation orientation) {
        return orientation.isVertical() ? 165 : 210;
    }

    public GaugeFigure() {
        this.coloredGauge = new RoundedRectangle();
        this.coloredGauge.setCornerDimensions(new Dimension(5, 5));
        this.coloredGauge.setBackgroundColor(ColorConstants.black);
        this.coloredGauge.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.coloredGauge);
        this.fullGauge = new RoundedRectangle();
        this.fullGauge.setCornerDimensions(new Dimension(5, 5));
        this.fullGauge.setForegroundColor(ColorConstants.black);
        this.fullGauge.setAlpha(100);
        this.add((IFigure)this.fullGauge);
        this.labelLabel = new Label();
        this.labelLabel.setText("");
        this.labelLabel.setForegroundColor(ColorConstants.black);
        this.labelLabel.setTextAlignment(2);
        this.labelLabel.setLabelAlignment(2);
        this.add((IFigure)this.labelLabel);
        this.minLabel = new Label();
        this.minLabel.setText("");
        this.minLabel.setForegroundColor(ColorConstants.black);
        this.minLabel.setTextAlignment(2);
        this.minLabel.setLabelAlignment(2);
        this.minLabel.setSize(70, 25);
        this.add((IFigure)this.minLabel);
        this.valueLabel = new Label();
        this.valueLabel.setText("");
        this.valueLabel.setForegroundColor(ColorConstants.black);
        this.valueLabel.setTextAlignment(2);
        this.valueLabel.setLabelAlignment(2);
        this.valueLabel.setSize(70, 25);
        this.add((IFigure)this.valueLabel);
        this.maxLabel = new Label();
        this.maxLabel.setText("");
        this.maxLabel.setForegroundColor(ColorConstants.black);
        this.maxLabel.setTextAlignment(2);
        this.maxLabel.setLabelAlignment(2);
        this.maxLabel.setSize(70, 25);
        this.add((IFigure)this.maxLabel);
    }

    public void setAlpha(int alpha) {
        if (!this.isOpaque()) {
            this.coloredGauge.setAlpha(alpha);
        }
    }

    public void setBackgroundColor(Color color) {
        this.coloredGauge.setBackgroundColor(color);
        this.coloredGauge.setForegroundColor(color);
    }

    public void setBounds(Rectangle rect) {
        int minWidth = Math.max(GaugeFigure.getMinWidth(this.orientation), rect.width);
        int minHeight = Math.max(GaugeFigure.getMinHeight(this.orientation), rect.height);
        Rectangle minedRect = new Rectangle(rect.x, rect.y, minWidth, minHeight);
        super.setBounds(minedRect);
        this.refresh(minedRect);
    }

    public void setForegroundColor(Color color) {
        this.minLabel.setForegroundColor(color);
        this.maxLabel.setForegroundColor(color);
        this.labelLabel.setForegroundColor(color);
        this.valueLabel.setForegroundColor(color);
    }

    public void setLabel(String label) {
        this.labelLabel.setText(label);
    }

    public void setOpaque(boolean opaque) {
        this.coloredGauge.setOpaque(opaque);
        if (opaque) {
            this.setAlpha(255);
        }
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        Rectangle centredBounds = this.getBounds().getCopy();
        centredBounds.x += centredBounds.width / 2;
        centredBounds.y += centredBounds.height / 2;
        this.setBounds(centredBounds);
    }

    public void setValue(double min, double max, double value, String unit) {
        double shownValue = value < min ? min : (value > max ? max : value);
        String formatToUse = "%".equals(unit) ? FORMAT_INTEGER : FORMAT_1_DIGITS;
        this.minLabel.setText(String.valueOf(String.format(formatToUse, min)) + unit);
        this.maxLabel.setText(String.valueOf(String.format(formatToUse, max)) + unit);
        this.valueLabel.setText(String.valueOf(String.format(FORMAT_1_DIGITS, value)) + unit);
        this.factor = (shownValue - min) / (max - min);
        this.refresh(this.getBounds());
    }

    private void refresh(Rectangle bounds) {
        this.refreshGauges(bounds);
        this.refreshLabels(bounds);
    }

    private void refreshGauges(Rectangle bounds) {
        if (this.orientation.isVertical()) {
            this.fullGauge.setBounds(new Rectangle(70, 0, bounds.width - 140, bounds.height - 25));
            int height = (int)((double)(bounds.height - 25) * this.factor);
            int y = !this.orientation.isReversed() ? bounds.height - 25 - height : 0;
            this.coloredGauge.setBounds(new Rectangle(70, y, bounds.width - 140, height));
        } else {
            this.fullGauge.setBounds(new Rectangle(0, 25, bounds.width, bounds.height - 25));
            int width = (int)((double)bounds.width * this.factor);
            int x = !this.orientation.isReversed() ? 0 : bounds.width - width;
            this.coloredGauge.setBounds(new Rectangle(x, 25, width, bounds.height - 25));
        }
    }

    private void refreshLabels(Rectangle bounds) {
        int maxLabelX;
        this.labelLabel.setSize(bounds.width, 25);
        int minLabelY = this.orientation.isVertical() ? bounds.height - 50 : 0;
        int n = maxLabelX = this.orientation.isVertical() ? 0 : bounds.width - 70;
        if (this.orientation.isReversed()) {
            this.minLabel.setLocation(new Point(maxLabelX, 0));
            this.maxLabel.setLocation(new Point(0, minLabelY));
        } else {
            this.minLabel.setLocation(new Point(0, minLabelY));
            this.maxLabel.setLocation(new Point(maxLabelX, 0));
        }
        int valueLabelX = (int)((double)maxLabelX * this.factor);
        int valueLabelY = (int)((double)minLabelY * this.factor);
        valueLabelX = this.orientation.isReversed() ? maxLabelX - valueLabelX : valueLabelX;
        int n2 = valueLabelY = this.orientation.isReversed() ? valueLabelY : minLabelY - valueLabelY;
        if (this.orientation.isVertical()) {
            valueLabelY = Math.max(25, Math.min(valueLabelY, minLabelY - 25));
            this.labelLabel.setLocation(new Point(0, bounds.height - 25));
        } else {
            valueLabelX = Math.max(70, Math.min(valueLabelX, maxLabelX - 70));
            this.labelLabel.setLocation(new Point(0, 25 + bounds.height / 2 - 25));
        }
        this.valueLabel.setLocation(new Point(valueLabelX, valueLabelY));
    }
}

