/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.gef.parts;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.widgets.model.Orientation;
import com.centreon.studio.map.client.elements.widgets.model.WidgetPropertyDescriptors;
import com.centreon.studio.map.client.elements.widgets.ui.gef.figures.GaugeFigure;
import com.centreon.studio.map.client.elements.widgets.ui.gef.parts.AWidgetGraphicalEditPart;
import com.centreon.studio.map.client.status.model.MetricData;
import com.centreon.studio.map.client.status.model.Status;
import com.centreon.studio.map.client.status.model.StatusPropertyDescriptors;
import com.centreon.studio.map.client.status.model.StatusTypes;
import com.centreon.studio.map.client.status.units.MetricFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;

public class GaugeWidgetGraphicalEditPart
extends AWidgetGraphicalEditPart {
    public GaugeWidgetGraphicalEditPart(INodeRelation relation) {
        super(relation);
    }

    public GaugeFigure getFigure() {
        return (GaugeFigure)super.getFigure();
    }

    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            if (relation.getTarget().getType() != StatusTypes.METRIC) continue;
            this.refreshVisuals();
            break;
        }
    }

    public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            if (relation.getTarget().getType() != StatusTypes.METRIC) continue;
            this.refreshVisuals();
            break;
        }
    }

    protected IFigure createFigure() {
        return new GaugeFigure();
    }

    protected void refreshVisuals() {
        GaugeFigure gaugeView = this.getFigure();
        INode gaugeModel = this.getModel().getTarget();
        SWTUtils.getDisplay().syncExec(() -> gaugeView.setOrientation((Orientation)((Object)((Object)gaugeModel.getProperty(WidgetPropertyDescriptors.ORIENTATION)))));
        super.refreshVisuals();
        SWTUtils.getDisplay().syncExec(() -> {
            Boolean useFontColor;
            INode metric;
            String metricId = (String)gaugeModel.getProperty(ElementPropertyDescriptors.METRIC_SOURCE);
            if (!Objects.equals(ElementPropertyDescriptors.METRIC_SOURCE.defaulValue, metricId) && (metric = INodeUtils.findNode((INode)gaugeModel, (TypeDescriptor)StatusTypes.METRIC, (Long)Long.valueOf(metricId.hashCode()), (PropertyValue[])new PropertyValue[0])) != null) {
                String unit = (String)metric.getProperty(StatusPropertyDescriptors.METRIC_UNIT);
                Double min = (Double)gaugeModel.getProperty(ElementPropertyDescriptors.METRIC1_MIN);
                Double max = (Double)gaugeModel.getProperty(ElementPropertyDescriptors.METRIC1_MAX);
                if (Double.isNaN(min)) {
                    min = (Double)metric.getProperty(StatusPropertyDescriptors.METRIC_MIN);
                }
                if (Double.isNaN(max)) {
                    max = (Double)metric.getProperty(StatusPropertyDescriptors.METRIC_MAX);
                }
                Double value = (Double)metric.getProperty(StatusPropertyDescriptors.METRIC_VALUE);
                ArrayList<Double> values = new ArrayList<Double>(3);
                values.add(min);
                values.add(value);
                values.add(max);
                String metricName = (String)metric.getProperty(StatusPropertyDescriptors.METRIC_NAME);
                MetricData metricData = new MetricData(metricName, null, unit, null, false);
                metricData.setValues(values);
                MetricFormatter formatter = MetricFormatter.getMetricFormatter((String)unit);
                if (formatter != null) {
                    metricData = formatter.optimizeSerie(metricData);
                    min = (Double)metricData.getValues().get(0);
                    value = (Double)metricData.getValues().get(1);
                    max = (Double)metricData.getValues().get(2);
                }
                gaugeView.setValue(min, max, value, metricData.getUnit());
            }
            INode ownStatusValue = (INode)gaugeModel.getProperty(StatusPropertyDescriptors.STATUS_OWN);
            Boolean useBackgroundColor = (Boolean)gaugeModel.getProperty(ElementPropertyDescriptors.USE_BACKROUND_STATUS_COLOR);
            if (useBackgroundColor.booleanValue()) {
                Color statusColor = Status.NA.equals((Object)ownStatusValue) ? null : StudioRegistries.colorRegistry().getSWTColorFrom((StudioColor)ownStatusValue.getProperty(PropertyDescriptors.COLOR));
                gaugeView.setBackgroundColor(statusColor);
            }
            if ((useFontColor = (Boolean)gaugeModel.getProperty(ElementPropertyDescriptors.USE_FONT_STATUS_COLOR)).booleanValue()) {
                Color statusColor = StudioRegistries.colorRegistry().getSWTColorFrom((StudioColor)ownStatusValue.getProperty(PropertyDescriptors.FONT_COLOR));
                gaugeView.setForegroundColor(statusColor);
            }
        });
    }
}

