/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.gef.parts;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.map.client.elements.gef.editparts.ShapeGraphicalEditPart;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.status.model.StatusPropertyDescriptors;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.util.Collection;
import org.eclipse.swt.graphics.Color;

public class OutputWidgetGraphicalEditPart
extends ShapeGraphicalEditPart {
    protected OutputWidgetGraphicalEditPart(INodeRelation relation) {
        super(relation);
    }

    public void activate() {
        if (!this.activated) {
            this.getModel().getTarget().registerRelationsListener((INodeRelationListener)this);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.activated) {
            this.getModel().getTarget().unregisterRelationsListener((INodeRelationListener)this);
        }
        super.deactivate();
    }

    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            if (!relation.getType().equals((Object)StatusTypes.METRIC)) continue;
            this.refreshVisuals();
            break;
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        SWTUtils.getDisplay().syncExec(() -> {
            Color swtColor;
            StudioColor studioColor;
            INode widget = this.getModel().getTarget();
            String createOutputString = (String)widget.getProperty(StatusPropertyDescriptors.OUTPUT_WIDGET_REALTIME_VALUE);
            this.getFigure().setLabel(createOutputString);
            INode status = (INode)widget.getProperty(StatusPropertyDescriptors.STATUS_OWN);
            if (((Boolean)widget.getProperty(ElementPropertyDescriptors.USE_BACKROUND_STATUS_COLOR)).booleanValue()) {
                studioColor = (StudioColor)status.getProperty(PropertyDescriptors.COLOR);
                swtColor = StudioRegistries.colorRegistry().getSWTColorFrom(studioColor);
                this.getFigure().setBackgroundColor(swtColor);
            }
            if (((Boolean)widget.getProperty(ElementPropertyDescriptors.USE_FONT_STATUS_COLOR)).booleanValue()) {
                studioColor = (StudioColor)status.getProperty(PropertyDescriptors.FONT_COLOR);
                swtColor = StudioRegistries.colorRegistry().getSWTColorFrom(studioColor);
                this.getFigure().setForegroundColor(swtColor);
            }
        });
    }
}

