/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.wizards;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.LayoutUtils;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.map.client.elements.model.ui.wizards.ElementPropertiesWizardPage;
import com.centreon.studio.map.client.elements.widgets.model.Orientation;
import com.centreon.studio.map.client.elements.widgets.model.WidgetPropertyDescriptors;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class GaugeWidgetPropertiesWizardPage
extends ElementPropertiesWizardPage
implements Listener {
    private Combo combo;
    private Orientation lastOrientation;

    protected GaugeWidgetPropertiesWizardPage() {
        super(GaugeWidgetPropertiesWizardPage.class.getSimpleName());
    }

    public Composite customCreateControl(Composite parent) {
        Composite composite = super.customCreateControl(parent);
        this.combo = CustomWizardPage.createDescriptorCombo((Composite)composite, (IObject)this.getInput().getTarget(), WidgetPropertyDescriptors.ORIENTATION, (Object[])Orientation.values());
        this.combo.addListener(13, (Listener)this);
        return composite;
    }

    public Point getPageSize() {
        Point size = super.getPageSize();
        size.y += 50;
        return size;
    }

    public void handleEvent(Event event) {
        Pos currentDim = (Pos)this.getInput().getProperty(PropertyDescriptors.CURRENT_DIMENSION);
        Pos minDim = LayoutUtils.INSTANCE.getMinDim(this.getInput());
        String text = this.combo.getText();
        Orientation selectedOrientation = Orientation.fromLabel(text);
        if (selectedOrientation.isVertical()) {
            if (!this.lastOrientation.isVertical()) {
                currentDim = Pos.create((double)currentDim.y, (double)currentDim.x);
            }
        } else if (this.lastOrientation.isVertical()) {
            currentDim = Pos.create((double)currentDim.y, (double)currentDim.x);
        }
        Pos newDim = Pos.create((double)Math.max(currentDim.x, minDim.x), (double)Math.max(currentDim.y, minDim.y));
        ((Text)this.widthField.getControl()).setText(String.valueOf(newDim.x.intValue()));
        ((Text)this.heightField.getControl()).setText(String.valueOf(newDim.y.intValue()));
        this.getInput().addPropertyValue(PropertyDescriptors.DIMENSION, (Object)newDim);
        this.lastOrientation = selectedOrientation;
    }

    protected boolean hasImage() {
        return false;
    }

    protected boolean hasParentResource() {
        return true;
    }

    protected void setInput(INodeRelation input) {
        super.setInput(input);
        this.lastOrientation = (Orientation)((Object)input.getTarget().getProperty(WidgetPropertyDescriptors.ORIENTATION));
    }
}

