/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.wizards;

import com.centreon.studio.client.commons.jface.validation.field.impl.CheckField;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.MetricLine;
import com.centreon.studio.map.client.status.message.StatusMessages;
import com.centreon.studio.map.client.status.model.GraphPropertyDescriptors;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

public class LineComposite {
    private final Composite composite;
    private final ColorSelector colorSelector;
    private final CheckField enableCheckField;
    private final Combo markerStyleCombo;
    private final Spinner markerSizeSpinner;
    private final String label;

    public LineComposite(Composite parent, String label, RGB color) {
        this.composite = SWTUtils.createComposite((Composite)parent, (int)6, (boolean)false);
        this.label = label;
        this.enableCheckField = new CheckField(SWTUtils.createButtonCheck((Composite)this.composite), this.label, Boolean.TRUE, null, null);
        SWTUtils.createSpanner((Composite)this.composite, (int)4, (int)0);
        this.markerSizeSpinner = SWTUtils.createSpiner((Composite)this.composite, (String)GraphPropertyDescriptors.CHART_MARKER_SIZE.label, (int)1, (int)0, (int)10, (int)1, (int)5);
        SWTUtils.createLabel((Composite)this.composite, (String)StatusMessages.chartMarkerStyle);
        this.markerStyleCombo = new Combo(this.composite, 4);
        for (MarkerType type : MarkerType.VALUES) {
            if (MarkerType.ICON_LITERAL.equals((Object)type)) continue;
            this.markerStyleCombo.add(type.getName());
        }
        this.colorSelector = new ColorSelector(this.composite);
        this.colorSelector.setColorValue(color);
    }

    public void dispose() {
        this.composite.dispose();
    }

    public String getColor() {
        RGB rgb = this.colorSelector.getColorValue();
        return String.valueOf(rgb.red) + ":" + rgb.green + ":" + rgb.blue;
    }

    public boolean getEnabled() {
        return this.enableCheckField.getValue();
    }

    public String getLabel() {
        return this.label;
    }

    public int getMarkerSize() {
        return this.markerSizeSpinner.getSelection();
    }

    public String getMarkerStyle() {
        return this.markerStyleCombo.getText();
    }

    public void updateValue(MetricLine metricLine) {
        this.markerSizeSpinner.setSelection(metricLine.getSize().intValue());
        this.markerStyleCombo.setText(metricLine.getStyle());
        this.enableCheckField.setValue((Object)metricLine.isVisible());
        String[] values = metricLine.getColor().split(":");
        RGB color = new RGB(Integer.valueOf(values[0]).intValue(), Integer.valueOf(values[1]).intValue(), Integer.valueOf(values[2]).intValue());
        this.colorSelector.setColorValue(color);
    }
}

