/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.wizards;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.ListOfMetricLine;
import com.centreon.studio.client.model.MetricLine;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.widgets.model.WidgetPropertyDescriptors;
import com.centreon.studio.map.client.elements.widgets.ui.wizards.LineComposite;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import com.centreon.studio.map.client.resources.model.repository.decorators.ResourceRepositoryDecorator;
import com.centreon.studio.map.client.status.GraphWebService;
import com.centreon.studio.map.client.status.model.GraphData;
import com.centreon.studio.map.client.status.model.MetricData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class LinesChartWidgetMetricsWizardPage
extends CustomWizardPage
implements IRepositoryListener {
    private static final Point PAGE_SIZE = new Point(400, 300);
    private final GraphWebService graphWebService;
    private final RepositoryDecorator resourceRepositoryDecorator;
    private Composite composite;
    private final Collection<LineComposite> lineComposites = new ArrayList<LineComposite>(5);

    protected LinesChartWidgetMetricsWizardPage(GraphWebService graphWebService, ResourceRepositoryDecorator resourceRepositoryDecorator) {
        super(LinesChartWidgetMetricsWizardPage.class.getSimpleName());
        this.graphWebService = graphWebService;
        this.resourceRepositoryDecorator = resourceRepositoryDecorator;
        this.resourceRepositoryDecorator.registerSelectionListener((IRepositoryListener)this);
    }

    private final void clearComposites() {
        Iterator<LineComposite> it = this.lineComposites.iterator();
        while (it.hasNext()) {
            LineComposite c = it.next();
            c.dispose();
            it.remove();
        }
    }

    private final void createLineWizard(MetricData metricData) {
        StudioColor studioColor = StudioColor.fromHexadecimal((String)metricData.getColor());
        RGB rgb = new RGB(studioColor.getRed(), studioColor.getGreen(), studioColor.getBlue());
        LineComposite lineComposite = new LineComposite(this.composite, metricData.getLabel(), rgb);
        ListOfMetricLine metricLines = (ListOfMetricLine)this.getInput().getTarget().getProperty(WidgetPropertyDescriptors.LINE_CHART_LINES);
        Optional<MetricLine> metricLine = metricLines.stream().filter(ml -> ml.getLabel().equals(metricData.getLabel())).findAny();
        metricLine.ifPresent(lineComposite::updateValue);
        this.lineComposites.add(lineComposite);
    }

    protected Composite customCreateControl(Composite parent) {
        this.composite = SWTUtils.createComposite((Composite)parent, (int)1, (boolean)false);
        long inputResourceId = (Long)this.getInput().getTarget().getProperty(ElementPropertyDescriptors.RESOURCE_ID);
        long resourceId = inputResourceId != (Long)ElementPropertyDescriptors.RESOURCE_ID.defaulValue ? inputResourceId : this.resourceRepositoryDecorator.getSelection().getTarget().getId();
        this.drawLines(resourceId);
        return this.composite;
    }

    public void dispose() {
        super.dispose();
        this.clearComposites();
        this.resourceRepositoryDecorator.unregisterSelectionListener((IRepositoryListener)this);
    }

    private void drawLines(long serviceId) {
        this.clearComposites();
        this.fillComposite(serviceId);
    }

    private final void fillComposite(long serviceId) {
        if (this.composite == null) {
            return;
        }
        GraphData graphData = this.graphWebService.getGraph(serviceId, 3600L, 10);
        graphData.getMetrics().stream().sorted((thisMetric, thatMetric) -> thisMetric.getLabel().compareTo(thatMetric.getLabel())).forEach(this::createLineWizard);
        this.composite.layout();
    }

    public Point getPageSize() {
        return PAGE_SIZE;
    }

    protected boolean performFinish() {
        ListOfMetricLine metricLines = new ListOfMetricLine(this.lineComposites.size());
        for (LineComposite lc : this.lineComposites) {
            String label = lc.getLabel();
            String style = lc.getMarkerStyle();
            int size = lc.getMarkerSize();
            String color = lc.getColor();
            boolean isEnabled = lc.getEnabled();
            MetricLine.MetricLineBuilder builder = new MetricLine.MetricLineBuilder(label);
            builder.setStyle(style).setSize(size).setColor(color).setVisible(isEnabled);
            metricLines.add((Object)builder.build());
        }
        this.getInput().getTarget().addPropertyValue(WidgetPropertyDescriptors.LINE_CHART_LINES, (Object)metricLines);
        this.resourceRepositoryDecorator.unregisterSelectionListener((IRepositoryListener)this);
        return true;
    }

    public void selectionChanged(Object source, IRepository repository) {
        INodeRelation relation = repository.getSelection();
        if (relation == null || !ResourceTypes.RESOURCE_SERVICE.equals((Object)relation.getTarget().getType())) {
            return;
        }
        this.clearComposites();
        this.fillComposite(relation.getTarget().getId());
    }

    protected void setInput(INodeRelation input) {
        super.setInput(input);
        long serviceId = (Long)input.getTarget().getProperty(ElementPropertyDescriptors.RESOURCE_ID);
        this.drawLines(serviceId);
    }
}

