/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons;

import com.centreon.studio.client.commons.PropertiesMapper;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.map.element.ElementDto;
import com.centreon.studio.map.element.ElementRelationDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class NodeMapper {
    public static INode dtoToNode(ElementDto dto, IRepository repository, PropertyValue ... values) {
        TypeDescriptor type = TypeDescriptor.getType((Integer)dto.getType());
        if (type == null) {
            return null;
        }
        INode node = NodeFactories.INSTANCE.create(type, Long.valueOf(dto.getId()), PropertiesMapper.dtoToProperties(dto.getProperties(), values), repository);
        if (node == null) {
            return null;
        }
        List dtos = dto.getElementRelations();
        ArrayList<INodeRelation> children = new ArrayList<INodeRelation>(dtos.size());
        for (ElementRelationDto childRelationDto : dtos) {
            INodeRelation relation = NodeMapper.dtoToRelation(childRelationDto, node, values);
            if (relation == null) continue;
            children.add(relation);
        }
        node.addRelations(children);
        return node;
    }

    public static INodeRelation dtoToRelation(ElementRelationDto dto, INode source, PropertyValue ... values) {
        Collection<PropertyValue> relationProps = PropertiesMapper.dtoToProperties(dto.getProperties(), values);
        TypeDescriptor type = TypeDescriptor.getType((Integer)dto.getType());
        INode relationTarget = NodeMapper.dtoToNode(dto.getChild(), source.getRepository(), values);
        if (relationTarget == null) {
            return null;
        }
        return NodeRelationFactories.INSTANCE.create(type, Long.valueOf(dto.getId()), source, relationTarget, relationProps);
    }

    public static ElementDto nodeToDto(INode node, boolean recursive) {
        if (node.getType().isLocal()) {
            return null;
        }
        ElementDto dto = new ElementDto();
        dto.setId(node.getId().longValue());
        dto.setType(node.getType().getId().intValue());
        dto.getProperties().addAll(PropertiesMapper.propertiesToDtos(node.getPropertyValues()));
        if (recursive) {
            List relations = node.getRelations(new TypeDescriptor[0]);
            ArrayList<ElementRelationDto> dtos = new ArrayList<ElementRelationDto>(relations.size());
            for (INodeRelation relation : relations) {
                ElementRelationDto relationDto = NodeMapper.relationToDto(relation, recursive);
                if (relationDto == null) continue;
                dtos.add(relationDto);
            }
            dto.getElementRelations().addAll(dtos);
        }
        return dto;
    }

    public static Collection<ElementRelationDto> relationsToDtos(Collection<INodeRelation> relations, boolean recursive) {
        ArrayList<ElementRelationDto> dtos = new ArrayList<ElementRelationDto>(relations.size());
        for (INodeRelation relation : relations) {
            dtos.add(NodeMapper.relationToDto(relation, recursive));
        }
        return dtos;
    }

    public static ElementRelationDto relationToDto(INodeRelation relation, boolean recursive) {
        if (relation.getType().isLocal() || relation.getTarget().getType().isLocal()) {
            return null;
        }
        ElementRelationDto dto = new ElementRelationDto();
        dto.setId(relation.getId().longValue());
        dto.setType(relation.getType().getId().intValue());
        dto.setParentId(relation.getSource().getId().longValue());
        dto.setChild(NodeMapper.nodeToDto(relation.getTarget(), recursive));
        dto.getProperties().addAll(PropertiesMapper.propertiesToDtos(relation.getPropertyValues()));
        return dto;
    }

    private NodeMapper() {
    }
}

