/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.jface;

import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.StudioFont;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public final class StudioRegistries {
    private static StudioColorRegistry colorRegistry;
    private static StudioImageRegistry imageRegistry;
    private static StudioFontRegistry fontRegistry;

    public static final synchronized StudioColorRegistry colorRegistry() {
        if (colorRegistry == null) {
            colorRegistry = new StudioColorRegistry();
        }
        return colorRegistry;
    }

    public static final synchronized StudioFontRegistry fontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = new StudioFontRegistry();
        }
        return fontRegistry;
    }

    public static final synchronized StudioImageRegistry imageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new StudioImageRegistry();
        }
        return imageRegistry;
    }

    private StudioRegistries() {
    }

    public static class StudioColorRegistry {
        private final ColorRegistry innerRegistry = JFaceResources.getColorRegistry();

        private StudioColorRegistry() {
        }

        public StudioColor getStudioColorFrom(RGB rgb) {
            return new StudioColor(rgb.red, rgb.green, rgb.blue);
        }

        public Color getSWTColorFrom(StudioColor studioColor) {
            if (studioColor == null) {
                return null;
            }
            String colorKey = studioColor.toHexadecimal();
            if (!this.innerRegistry.hasValueFor(colorKey)) {
                RGB rgb = new RGB(studioColor.getRed(), studioColor.getGreen(), studioColor.getBlue());
                this.innerRegistry.put(colorKey, rgb);
            }
            return this.innerRegistry.get(colorKey);
        }
    }

    public static class StudioFontRegistry {
        private final FontRegistry innerRegistry = JFaceResources.getFontRegistry();

        private StudioFontRegistry() {
            this.innerRegistry.put("default", this.getSWTFontFrom(StudioFont.DEFAULT).getFontData());
        }

        public Font getBold(String symbolicName) {
            return this.innerRegistry.getBold(symbolicName);
        }

        public StudioFont getStudioFontFrom(FontData fontData) {
            return new StudioFont(fontData.getName(), fontData.getHeight(), StudioFont.Style.fromId(fontData.getStyle()), fontData.getLocale());
        }

        public Font getSWTFontFrom(StudioFont studioFont) {
            if (studioFont == null) {
                return null;
            }
            String fontKey = studioFont.toFormatedString();
            if (!this.innerRegistry.hasValueFor(fontKey)) {
                FontData[] fontData = new FontData[]{new FontData(studioFont.getName(), studioFont.getHeight(), studioFont.getStyle().getId())};
                this.innerRegistry.put(fontKey, fontData);
            }
            return this.innerRegistry.get(fontKey);
        }
    }

    public static class StudioImageRegistry {
        private final Map<String, Image> images = new HashMap<String, Image>(8);

        private StudioImageRegistry() {
        }

        public Image get(String name) {
            return this.images.get(name);
        }

        public void register(String name, Image image) {
            Image lastImage = this.images.put(name, image);
            if (lastImage != null && !lastImage.isDisposed()) {
                lastImage.dispose();
            }
        }
    }
}

