/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.jface.validation;

import com.centreon.studio.client.commons.messages.CommonsMessages;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public final class ControlValidators {
    public static final Image IMAGE_REQUIRED = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage();
    public static final Image IMAGE_WARNING = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
    public static final Image IMAGE_ERROR = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    public static final Image IMAGE_INFO = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
    public static final IControlValidator<Combo> COMBO_NON_EMPTY_VALIDATOR = new AControlValidator<Combo>(){

        @Override
        public String getMessage() {
            return CommonsMessages.errorComboEmpty;
        }

        @Override
        public boolean validate(Combo combo) {
            return combo.getText().length() > 0;
        }
    };
    public static final IControlValidator<Text> INT_POSITIVE_VALIDATOR = new AControlValidator<Text>(){

        @Override
        public String getMessage() {
            return CommonsMessages.errorTextNotInt;
        }

        @Override
        public boolean validate(Text text) {
            block3: {
                try {
                    if (text.isEnabled()) break block3;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            int value = Integer.parseInt(text.getText());
            return value > 0;
        }
    };
    public static final IControlValidator<Text> DOUBLE_VALIDATOR = new AControlValidator<Text>(){

        @Override
        public String getMessage() {
            return CommonsMessages.errorTextNotDouble;
        }

        @Override
        public boolean validate(Text text) {
            if (!text.isEnabled()) {
                return false;
            }
            try {
                Double.valueOf(text.getText());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    };
    public static final IControlValidator<Text> DOUBLE_POSITIVE_VALIDATOR = new AControlValidator<Text>(){

        @Override
        public String getMessage() {
            return CommonsMessages.errorTextNotDouble;
        }

        @Override
        public boolean validate(Text text) {
            block3: {
                try {
                    if (text.isEnabled()) break block3;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            double value = Double.parseDouble(text.getText());
            return value >= 0.0;
        }
    };
    public static final IControlValidator<Text> TEXT_NON_EMPTY_VALIDATOR = new AControlValidator<Text>(){

        @Override
        public String getMessage() {
            return CommonsMessages.errorTextEmpty;
        }

        @Override
        public boolean validate(Text text) {
            return !text.isEnabled() || text.getText().length() > 0;
        }
    };
    public static final IControlValidator<Text> TEXT_NO_SPACE_NON_EMPTY_VALIDATOR = new AControlValidator<Text>(){

        @Override
        public String getMessage() {
            return CommonsMessages.errorTextEmptyOrWithSpace;
        }

        @Override
        public boolean validate(Text text) {
            return !text.isEnabled() || text.getText().length() > 0 && !text.getText().contains(" ");
        }
    };

    public static IControlValidator<Text> createDoubleValidator(final MinMaxProvider<Double> provider) {
        return new AControlValidator<Text>(){
            private String message;

            @Override
            public String getMessage() {
                return this.message;
            }

            @Override
            public boolean validate(Text text) {
                block4: {
                    try {
                        if (text.isEnabled()) break block4;
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.message = CommonsMessages.errorTextNotDouble;
                        return false;
                    }
                }
                double value = Double.parseDouble(text.getText());
                if (value < (Double)provider.min() || value > (Double)provider.max()) {
                    this.message = NLS.bind((String)CommonsMessages.errorInterval, provider.min(), provider.max());
                    return false;
                }
                return true;
            }
        };
    }

    public static IControlValidator<Text> createIntValidator(final MinMaxProvider<Integer> provider) {
        return new AControlValidator<Text>(){
            private String message;

            @Override
            public String getMessage() {
                return this.message;
            }

            @Override
            public boolean validate(Text text) {
                block4: {
                    try {
                        if (text.isEnabled()) break block4;
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.message = CommonsMessages.errorTextNotInt;
                        return false;
                    }
                }
                int value = Integer.parseInt(text.getText());
                if (value < (Integer)provider.min() || value > (Integer)provider.max()) {
                    this.message = NLS.bind((String)CommonsMessages.errorInterval, provider.min(), provider.max());
                    return false;
                }
                return true;
            }
        };
    }

    private ControlValidators() {
    }

    public static abstract class AControlValidator<C extends Control>
    implements IControlValidator<C> {
        @Override
        public Image getImage() {
            return IMAGE_ERROR;
        }
    }

    public static interface IControlValidator<C extends Control> {
        public Image getImage();

        public String getMessage();

        public boolean validate(C var1);
    }

    public static interface MinMaxProvider<T extends Number> {
        public T max();

        public T min();
    }
}

