/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.jface.validation.field.impl;

import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.TextWithButtonField;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.SWTUtils;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;

public class FileField
extends TextWithButtonField {
    private final String[] extLabels;
    private final String[] exts;
    private final int style;

    public FileField(Composite parent, String label, String value, IForm form, ControlValidators.IControlValidator<Text> validator, int style) {
        this(parent, label, value, form, validator, style, null, null);
    }

    public FileField(Composite parent, String label, String value, IForm form, ControlValidators.IControlValidator<Text> validator, int style, String[] exts, String[] extLabels) {
        super(parent, label, CommonsMessages.keywordBrowse, value, form, validator);
        Assert.isTrue((exts == null || extLabels != null && exts.length == extLabels.length ? 1 : 0) != 0, (String)"extension labels must contain as much entry as extensions does");
        this.extLabels = extLabels == null ? null : Arrays.copyOf(extLabels, extLabels.length);
        this.exts = exts == null ? null : Arrays.copyOf(exts, exts.length);
        this.style = style;
    }

    @Override
    protected String getButtonValue() {
        FileDialog fileDialog = new FileDialog(SWTUtils.getDisplay().getActiveShell(), this.style);
        fileDialog.setText("Pick a file");
        fileDialog.setFileName((String)this.value);
        fileDialog.setFilterPath((String)this.value);
        if (this.exts != null && this.exts.length > 0) {
            fileDialog.setFilterExtensions(this.exts);
            fileDialog.setFilterNames(this.extLabels);
        }
        return fileDialog.open();
    }
}

