/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.jface.validation.form;

import com.centreon.studio.client.commons.jface.validation.form.IForm;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public final class Form
implements IForm {
    private static final int VALIDATED = 1;
    private static final int CHANGED = 2;
    private final Map<Runnable, Integer> trackingRunnableToTrackedStatus;
    private final Map<Control, Integer> trackingControlToTrackedStatus;
    private final Map<Control, Integer> trackedControlToTrackedStatus;
    private boolean changed;
    private boolean valid;
    private final boolean trackValidation;
    private final boolean trackChange;

    public Form() {
        this(true, true);
    }

    public Form(boolean trackChange, boolean trackValidation) {
        this.trackChange = trackChange;
        this.trackValidation = trackValidation;
        this.trackedControlToTrackedStatus = new HashMap<Control, Integer>(4);
        this.trackingControlToTrackedStatus = new HashMap<Control, Integer>(4);
        this.trackingRunnableToTrackedStatus = new HashMap<Runnable, Integer>(4);
    }

    @Override
    public boolean hasChanged() {
        return !this.trackChange || this.changed;
    }

    @Override
    public boolean isValid() {
        return !this.trackValidation || this.valid;
    }

    @Override
    public void registerChangeTrackingControl(Control control) {
        this.registerControl(control, 2);
    }

    @Override
    public void registerChangeTrackingRunnable(Runnable runnable) {
        this.registerRunnable(runnable, 2);
    }

    @Override
    public void registerValidationTrackingControl(Control control) {
        this.registerControl(control, 1);
    }

    @Override
    public void registerValidationTrackingRunnable(Runnable runnable) {
        this.registerRunnable(runnable, 1);
    }

    @Override
    public void setChange(final Control control, boolean value) {
        if (control == null) {
            return;
        }
        Integer status = this.trackedControlToTrackedStatus.get(control);
        if (status == null) {
            status = 0;
        }
        status = value ? Integer.valueOf(status | 2) : Integer.valueOf(status & 1);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Form.this.trackedControlToTrackedStatus.remove(control);
            }
        });
        this.trackedControlToTrackedStatus.put(control, status);
        this.apply();
    }

    @Override
    public void setValidation(final Control control, boolean value) {
        if (control == null) {
            return;
        }
        Integer status = this.trackedControlToTrackedStatus.get(control);
        if (status == null) {
            status = 0;
        }
        status = value ? Integer.valueOf(status | 1) : Integer.valueOf(status & 2);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Form.this.trackedControlToTrackedStatus.remove(control);
            }
        });
        this.trackedControlToTrackedStatus.put(control, status);
        this.apply();
    }

    private void apply() {
        this.valid = true;
        for (int status : this.trackedControlToTrackedStatus.values()) {
            if ((status & 1) == 1) continue;
            this.valid = false;
            break;
        }
        this.changed = false;
        for (int change : this.trackedControlToTrackedStatus.values()) {
            this.changed |= (change & 2) == 2;
        }
        this.applyToControls();
        this.runRunnables();
    }

    private void applyToControls() {
        for (Map.Entry<Control, Integer> entry : this.trackingControlToTrackedStatus.entrySet()) {
            Control control = entry.getKey();
            if (control == null || control.isDisposed()) continue;
            int action = entry.getValue();
            boolean trackingChange = this.trackChange && (action & 2) == 2;
            boolean trackingValidation = this.trackValidation && (action & 1) == 1;
            control.setEnabled(!(trackingChange && !this.changed || trackingValidation && !this.valid));
        }
    }

    private void registerControl(final Control control, int action) {
        if (control == null) {
            return;
        }
        Integer currentAction = this.trackingControlToTrackedStatus.get(control);
        if (currentAction == null) {
            currentAction = 0;
        }
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Form.this.trackingControlToTrackedStatus.remove(control);
            }
        });
        this.trackingControlToTrackedStatus.put(control, currentAction | action);
        this.apply();
    }

    private void registerRunnable(Runnable runnable, int action) {
        if (runnable == null) {
            return;
        }
        Integer currentActioin = this.trackingRunnableToTrackedStatus.get(runnable);
        if (currentActioin == null) {
            currentActioin = 0;
        }
        this.trackingRunnableToTrackedStatus.put(runnable, action | currentActioin);
        this.apply();
    }

    private void runRunnables() {
        for (Map.Entry<Runnable, Integer> entry : this.trackingRunnableToTrackedStatus.entrySet()) {
            boolean trackingValidation;
            Runnable runnable = entry.getKey();
            if (runnable == null) continue;
            int action = entry.getValue();
            boolean trackingChange = (action & 2) == 2;
            boolean bl = trackingValidation = (action & 1) == 1;
            if (trackingChange && (!this.changed || trackingValidation) && !this.valid) continue;
            runnable.run();
        }
    }
}

