/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.swt;

import com.centreon.studio.client.commons.swt.SWT2Dutil;
import java.awt.geom.AffineTransform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class SWTImageCanvas
extends Canvas {
    private static final float ZOOMIN_RATE = 1.1f;
    private static final float ZOOMOUT_RATE = 0.9f;
    private Image sourceImage;
    private Image screenImage;
    private AffineTransform transform = new AffineTransform();

    public SWTImageCanvas(Composite parent) {
        this(parent, 0);
    }

    private SWTImageCanvas(Composite parent, int style) {
        super(parent, style | 0x200 | 0x100 | 0x40000);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                SWTImageCanvas.this.syncScrollBars();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                SWTImageCanvas.this.paint(event.gc);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int move = 0;
                boolean vertical = true;
                switch (e.keyCode) {
                    case 0x1000002: {
                        move = 10;
                        break;
                    }
                    case 0x1000001: {
                        move = -10;
                        break;
                    }
                    case 0x1000006: {
                        move = 100;
                        break;
                    }
                    case 0x1000005: {
                        move = -100;
                        break;
                    }
                    case 0x1000003: {
                        move = -10;
                        vertical = false;
                        break;
                    }
                    case 0x1000004: {
                        move = 10;
                        vertical = false;
                        break;
                    }
                }
                if (vertical) {
                    SWTImageCanvas.this.getVerticalBar().setSelection(SWTImageCanvas.this.getVerticalBar().getSelection() + move);
                    SWTImageCanvas.this.scrollVertically(SWTImageCanvas.this.getVerticalBar());
                } else {
                    SWTImageCanvas.this.getHorizontalBar().setSelection(SWTImageCanvas.this.getHorizontalBar().getSelection() + move);
                    SWTImageCanvas.this.scrollHorizontally(SWTImageCanvas.this.getHorizontalBar());
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if (e.stateMask == SWT.MOD1) {
                    while (e.count >= 3) {
                        SWTImageCanvas.this.zoomIn();
                        e.count -= 3;
                    }
                    while (e.count <= -3) {
                        SWTImageCanvas.this.zoomOut();
                        e.count += 3;
                    }
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.button == 2) {
                    SWTImageCanvas.this.showOriginal();
                }
            }
        });
        this.initScrollBars();
    }

    public void dispose() {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
        }
        if (this.screenImage != null && !this.screenImage.isDisposed()) {
            this.screenImage.dispose();
        }
    }

    public Image loadImage(String filename) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        this.sourceImage = new Image((Device)this.getDisplay(), filename);
        this.showOriginal();
        return this.sourceImage;
    }

    public void setImageData(ImageData data) {
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
        }
        if (data != null) {
            this.sourceImage = new Image((Device)this.getDisplay(), data);
        }
        this.syncScrollBars();
    }

    private void centerZoom(double dx, double dy, double scale, AffineTransform af) {
        af.preConcatenate(AffineTransform.getTranslateInstance(-dx, -dy));
        af.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        af.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        this.transform = af;
        this.syncScrollBars();
    }

    private void initScrollBars() {
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setEnabled(false);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SWTImageCanvas.this.scrollHorizontally((ScrollBar)event.widget);
            }
        });
        ScrollBar vertical = this.getVerticalBar();
        vertical.setEnabled(false);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SWTImageCanvas.this.scrollVertically((ScrollBar)event.widget);
            }
        });
    }

    private void paint(GC gc) {
        Rectangle clientRect = this.getClientArea();
        if (this.sourceImage != null) {
            Rectangle imageRect = SWT2Dutil.inverseTransformRect(this.transform, clientRect);
            imageRect.x -= 2;
            imageRect.y -= 2;
            imageRect.width += 4;
            imageRect.height += 4;
            Rectangle imageBound = this.sourceImage.getBounds();
            imageRect = imageRect.intersection(imageBound);
            Rectangle destRect = SWT2Dutil.transformRect(this.transform, imageRect);
            if (this.screenImage != null) {
                this.screenImage.dispose();
            }
            this.screenImage = new Image((Device)this.getDisplay(), clientRect.width, clientRect.height);
            GC newGC = new GC((Drawable)this.screenImage);
            newGC.setClipping(clientRect);
            newGC.setInterpolation(2);
            newGC.setAntialias(1);
            newGC.drawImage(this.sourceImage, imageRect.x, imageRect.y, imageRect.width, imageRect.height, destRect.x, destRect.y, destRect.width, destRect.height);
            newGC.dispose();
            gc.drawImage(this.screenImage, 0, 0);
        } else {
            gc.setClipping(clientRect);
            gc.fillRectangle(clientRect);
            this.initScrollBars();
        }
    }

    private void scrollHorizontally(ScrollBar scrollBar) {
        if (this.sourceImage == null) {
            return;
        }
        AffineTransform af = this.transform;
        double tx = af.getTranslateX();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(select - tx, 0.0));
        this.transform = af;
        this.syncScrollBars();
    }

    private void scrollVertically(ScrollBar scrollBar) {
        if (this.sourceImage == null) {
            return;
        }
        AffineTransform af = this.transform;
        double ty = af.getTranslateY();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(0.0, select - ty));
        this.transform = af;
        this.syncScrollBars();
    }

    private void showOriginal() {
        if (this.sourceImage == null) {
            return;
        }
        this.transform = new AffineTransform();
        this.syncScrollBars();
    }

    private void syncScrollBars() {
        if (this.sourceImage == null) {
            this.redraw();
            return;
        }
        AffineTransform af = this.transform;
        double sx = af.getScaleX();
        double sy = af.getScaleY();
        double tx = af.getTranslateX();
        double ty = af.getTranslateY();
        if (tx > 0.0) {
            tx = 0.0;
        }
        if (ty > 0.0) {
            ty = 0.0;
        }
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setIncrement(this.getClientArea().width / 100);
        horizontal.setPageIncrement(this.getClientArea().width);
        Rectangle imageBound = this.sourceImage.getBounds();
        int cw = this.getClientArea().width;
        int ch = this.getClientArea().height;
        if ((double)imageBound.width * sx > (double)cw) {
            horizontal.setMaximum((int)((double)imageBound.width * sx));
            horizontal.setEnabled(true);
            if ((int)(-tx) > horizontal.getMaximum() - cw) {
                tx = -horizontal.getMaximum() + cw;
            }
        } else {
            horizontal.setEnabled(false);
            tx = ((double)cw - (double)imageBound.width * sx) / 2.0;
        }
        horizontal.setSelection((int)(-tx));
        horizontal.setThumb(this.getClientArea().width);
        ScrollBar vertical = this.getVerticalBar();
        vertical.setIncrement(this.getClientArea().height / 100);
        vertical.setPageIncrement(this.getClientArea().height);
        if ((double)imageBound.height * sy > (double)ch) {
            vertical.setMaximum((int)((double)imageBound.height * sy));
            vertical.setEnabled(true);
            if ((int)(-ty) > vertical.getMaximum() - ch) {
                ty = -vertical.getMaximum() + ch;
            }
        } else {
            vertical.setEnabled(false);
            ty = ((double)ch - (double)imageBound.height * sy) / 2.0;
        }
        vertical.setSelection((int)(-ty));
        vertical.setThumb(this.getClientArea().height);
        af = AffineTransform.getScaleInstance(sx, sy);
        af.preConcatenate(AffineTransform.getTranslateInstance(tx, ty));
        this.transform = af;
        this.redraw();
    }

    private void zoomIn() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle rect = this.getClientArea();
        int w = rect.width;
        int h = rect.height;
        double dx = (double)w / 2.0;
        double dy = (double)h / 2.0;
        this.centerZoom(dx, dy, 1.1f, this.transform);
    }

    private void zoomOut() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle rect = this.getClientArea();
        int w = rect.width;
        int h = rect.height;
        double dx = (double)w / 2.0;
        double dy = (double)h / 2.0;
        this.centerZoom(dx, dy, 0.9f, this.transform);
    }
}

