/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.swt;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.swt.CustomScale;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.utils.OsUtils;
import com.centreon.studio.client.utils.StringUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public final class SWTUtils {
    public static final String ERROR_IMAGE_PATH = "platform:/plugin/com.centreon.studio.client.commons/img/broken.png";
    public static final String QUESTION_IMAGE_PATH = "platform:/plugin/com.centreon.studio.client.commons/img/blue-question-mark-small.png";
    private static final RGB RESIZE_TRANSPARENT_RGB = new RGB(255, 255, 255);
    private static final int DEFAULT_BUTTON_WIDTH = 100;

    public static Button createButton(Composite parent, int style, Image image, GridData data, SelectionListener listener) {
        Button button = SWTUtils.createButton(parent, style, "", data, listener);
        button.setImage(image);
        return button;
    }

    public static Button createButton(Composite parent, int style, String text, GridData data, SelectionListener listener) {
        Button button = new Button(parent, style);
        button.setLayoutData((Object)data);
        button.setText(text);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public static Button createButtonCheck(Composite parent) {
        return SWTUtils.createButtonCheck(parent, "");
    }

    public static Button createButtonCheck(Composite parent, String label) {
        return SWTUtils.createButton(parent, 32, label, SWTUtils.createGridData(1, 0x1000000, -1, -1), null);
    }

    public static Button createButtonDefault(Composite parent, int alignH, int alignV, String text, SelectionListener listener) {
        Button defaultButton = SWTUtils.createButtonPush(parent, alignH, alignV, text, listener);
        parent.getShell().setDefaultButton(defaultButton);
        return defaultButton;
    }

    public static Button createButtonPush(Composite parent, GridData data, Image image, SelectionListener listener) {
        return SWTUtils.createButton(parent, 8, image, data, listener);
    }

    public static Button createButtonPush(Composite parent, GridData data, String text, SelectionListener listener) {
        return SWTUtils.createButton(parent, 8, text, data, listener);
    }

    public static Button createButtonPush(Composite parent, int alignH, int alignV, Image image, SelectionListener listener) {
        Button button = SWTUtils.createButton(parent, 8, "", SWTUtils.createGridData(alignH, alignV, -1, -1), listener);
        button.setImage(image);
        return button;
    }

    public static Button createButtonPush(Composite parent, int alignH, int alignV, String text, SelectionListener listener) {
        return SWTUtils.createButton(parent, 8, text, SWTUtils.createGridData(alignH, alignV, 100, -1), listener);
    }

    public static Combo createCombo(Composite parent, int style, Object[] values, GridData data, SelectionListener listener) {
        Combo combo = new Combo(parent, style | 0x800);
        combo.setLayoutData((Object)data);
        if (values != null) {
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                combo.add(value.toString());
                combo.setData(value.toString(), value);
                ++n2;
            }
        }
        if (listener != null) {
            combo.addSelectionListener(listener);
        }
        return combo;
    }

    public static Composite createComposite(Composite parent, int columns, boolean equal) {
        return SWTUtils.createComposite(parent, columns, equal, -1, -1, SWTUtils.createGridDataFill());
    }

    public static Composite createComposite(Composite parent, int columns, boolean equal, int margins, int spacing) {
        return SWTUtils.createComposite(parent, columns, equal, margins, spacing, SWTUtils.createGridDataFill());
    }

    public static Composite createComposite(Composite parent, int columns, boolean equal, int margins, int spacing, GridData data) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SWTUtils.createGridLayout(columns, equal, margins, spacing));
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Composite createComposite(Composite parent, int columns, boolean equal, int margins, int spacing, int hspan, int vspan) {
        GridData gd = SWTUtils.createGridDataFill();
        gd.horizontalSpan = hspan;
        gd.verticalSpan = vspan;
        return SWTUtils.createComposite(parent, columns, equal, margins, spacing, gd);
    }

    public static DateTime createDateTime(Composite parent, String label, final Calendar calendar, int style, SelectionListener listener) {
        Assert.isTrue((style == 128 || style == 32 || style == 1024 ? 1 : 0) != 0);
        if (label != null) {
            SWTUtils.createLabel(parent, label, 1, 0x1000000, 100, -1);
        }
        final DateTime dateTime = new DateTime(parent, 0x804 | style);
        dateTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        dateTime.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        dateTime.setTime(calendar.get(11), calendar.get(12), calendar.get(13));
        dateTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                calendar.set(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getHours(), dateTime.getMinutes(), dateTime.getSeconds());
            }
        });
        if (listener != null) {
            dateTime.addSelectionListener(listener);
        }
        return dateTime;
    }

    public static GridData createGridData(int alignH, int alignV, int width, int height) {
        GridData data = new GridData(alignH, alignV, alignH == 4, alignV == 4);
        data.widthHint = width;
        data.heightHint = height;
        return data;
    }

    public static GridData createGridDataFill() {
        return new GridData(4, 4, true, true);
    }

    public static GridData createGridDataHorizontalFill() {
        return new GridData(4, 0x1000000, true, false);
    }

    public static GridLayout createGridLayout(int columns, boolean equals, int margins, int spacing) {
        GridLayout layout = new GridLayout(columns, equals);
        layout.marginHeight = margins == -1 ? layout.marginHeight : margins;
        layout.marginWidth = margins == -1 ? layout.marginWidth : margins;
        layout.horizontalSpacing = spacing == -1 ? layout.horizontalSpacing : spacing;
        layout.verticalSpacing = spacing == -1 ? layout.verticalSpacing : spacing;
        return layout;
    }

    public static Group createGroup(Composite parent, String label, int margins, int columnNumber, boolean equal, GridData data) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)SWTUtils.createGridLayout(columnNumber, equal, margins, margins));
        group.setLayoutData((Object)data);
        group.setText(label);
        return group;
    }

    public static Label createLabel(Composite parent, String text) {
        return SWTUtils.createLabel(parent, text, 0x1000008);
    }

    public static Label createLabel(Composite parent, String text, int hAlign) {
        return SWTUtils.createLabel(parent, text, hAlign, 0x1000000, -1, -1);
    }

    public static Label createLabel(Composite parent, String text, int alignH, int alignV, int width, int height) {
        Label label = new Label(parent, 65);
        label.setLayoutData((Object)SWTUtils.createGridData(alignH, alignV, width, height));
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    public static Text createPassword(Composite parent) {
        return SWTUtils.createText(parent, 0x400800, -1, -1);
    }

    public static Button createRadioButton(Composite parent, String label) {
        return SWTUtils.createButton(parent, 16, label, SWTUtils.createGridData(1, 0x1000000, -1, -1), null);
    }

    public static CustomScale createScale(Composite parent, String label, int value, int max) {
        if (label != null) {
            SWTUtils.createLabel(parent, label);
        }
        CustomScale scale = new CustomScale(parent, 0);
        scale.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        scale.setPageIncrement(max / 10);
        scale.setMaximum(max);
        scale.setIncrement(1);
        scale.setSelection(value);
        return scale;
    }

    public static Shell createShellDialog() {
        Shell shell = new Shell(SWTUtils.getDisplay(), 18528);
        shell.setLayout((Layout)new GridLayout());
        return shell;
    }

    public static Shell createShellTool(int columns, boolean modal, boolean resizable, boolean onTop, int whites, boolean equals) {
        Shell shell = new Shell(SWTUtils.getDisplay(), 4 | (onTop ? 16384 : 0) | (modal ? 65536 : 0) | (resizable ? 16 : 0));
        shell.setLayout((Layout)SWTUtils.createGridLayout(columns, equals, whites, whites));
        return shell;
    }

    public static Label createSpanner(Composite parent, int columns, int rows) {
        Label spanner = new Label(parent, 0);
        spanner.setLayoutData((Object)new GridData(4, 4, false, false, columns, rows));
        return spanner;
    }

    public static Spinner createSpiner(Composite composite, String label, int value, int min, int max, int inc, int pageInc) {
        if (label != null) {
            SWTUtils.createLabel(composite, label);
        }
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setLayoutData((Object)SWTUtils.createGridData(4, 0x1000000, -1, -1));
        spinner.setValues(value, min, max, 0, inc, pageInc);
        return spinner;
    }

    public static Text createText(Composite parent) {
        return SWTUtils.createText(parent, 2048, -1, -1);
    }

    public static Text createText(Composite parent, int style, int height, int width) {
        final Text text = new Text(parent, style);
        text.setLayoutData((Object)SWTUtils.createGridData(4, 0x1000000, width, height));
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                text.selectAll();
            }
        });
        return text;
    }

    public static Monitor getCursorMonitor() {
        Display display = SWTUtils.getDisplay();
        Point cursor = display.getCursorLocation();
        Monitor monitor = null;
        Monitor[] monitorArray = display.getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor m = monitorArray[n2];
            if (m.getBounds().contains(cursor)) {
                monitor = m;
            }
            ++n2;
        }
        if (monitor == null) {
            monitor = display.getPrimaryMonitor();
        }
        return monitor;
    }

    public static Display getDisplay() {
        Display d = Display.getCurrent();
        if (d != null) {
            return d;
        }
        return Display.getDefault();
    }

    public static Image getImageFromUrl(String path) {
        return SWTUtils.getImageFromUrl(path, -1, -1, false);
    }

    public static Image getImageFromUrl(String path, int width, int height) {
        return SWTUtils.getImageFromUrl(path, width, height, false);
    }

    public static synchronized Image getImageFromUrl(String path, int width, int height, boolean keepRatio) {
        if (StringUtils.isNullEmptyOrBlank((String)path)) {
            return null;
        }
        Pos size = Pos.create(width, height);
        String key = String.valueOf(path) + size.toString();
        Image image = StudioRegistries.imageRegistry().get(key);
        if (image != null && !image.isDisposed()) {
            return image;
        }
        try {
            URL url = new URL(path);
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream stream = url.openStream();){
                image = new Image((Device)Display.getDefault(), stream);
                Pos imageSize = Pos.create(image.getImageData().width, image.getImageData().height);
                if (width != -1 && imageSize.x.intValue() != width || height != -1 && imageSize.y.intValue() != height) {
                    if (keepRatio) {
                        size = Pos.toRatio(imageSize, Pos.create(width, height));
                    }
                    image = SWTUtils.resizeImage(image, size.x.intValue(), size.y.intValue(), true);
                }
                StudioRegistries.imageRegistry().register(key, image);
                return image;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return SWTUtils.getImageFromUrl(ERROR_IMAGE_PATH);
        }
    }

    public static Color getSystemColor(int color) {
        return SWTUtils.getDisplay().getSystemColor(color);
    }

    public static Image resizeImage(Image source, int width, int height, boolean disposeSource) {
        Rectangle bounds = source.getBounds();
        if (bounds.width == width && bounds.height == height || width <= 0 || height <= 0) {
            return source;
        }
        Image resizedImage = new Image((Device)SWTUtils.getDisplay(), width, height);
        GC gc = new GC((Drawable)resizedImage);
        gc.setInterpolation(2);
        gc.setAntialias(1);
        gc.setAdvanced(true);
        gc.drawImage(source, 0, 0, bounds.width, bounds.height, 0, 0, width, height);
        gc.dispose();
        ImageData sourceData = source.getImageData();
        if (disposeSource) {
            source.dispose();
        }
        ImageData resizedData = resizedImage.getImageData();
        if (sourceData.getTransparencyType() == 4) {
            RGB rgb = sourceData.palette.getRGB(sourceData.transparentPixel);
            resizedData.transparentPixel = resizedData.palette.getPixel(rgb);
            resizedImage.dispose();
            return new Image((Device)SWTUtils.getDisplay(), resizedData);
        }
        if (sourceData.getTransparencyType() == 1) {
            byte[] alphaData = new byte[resizedData.data.length / 4];
            int i = 0;
            while (i < resizedData.data.length / 4) {
                alphaData[i] = OsUtils.isWindows() ? resizedData.data[i * 4 + 3] : (byte)(resizedData.data[i * 4 + 3] == -1 ? 0 : -1);
                ++i;
            }
            resizedData.alphaData = alphaData;
            resizedImage.dispose();
            return new Image((Device)SWTUtils.getDisplay(), resizedData);
        }
        if (sourceData.getTransparencyType() == 2) {
            System.out.println(" ----------------------------------- TRANSPARENCY_MASK ");
        }
        return resizedImage;
    }

    public static Image transparentImage(Image source, RGB backgroundColor, boolean disposeSource) {
        if (source == null) {
            return null;
        }
        ImageData data = source.getImageData();
        if (backgroundColor == null) {
            return SWTUtils.transparentImage(source, RESIZE_TRANSPARENT_RGB, disposeSource);
        }
        try {
            data.alpha = -1;
            data.maskData = null;
            data.transparentPixel = data.palette.getPixel(backgroundColor);
            Image image = new Image((Device)SWTUtils.getDisplay(), data);
            return image;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Image image = source;
            return image;
        }
        finally {
            if (disposeSource) {
                source.dispose();
            }
        }
    }

    private SWTUtils() {
    }
}

