/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public final class FilterData {
    public final String value;
    public final boolean caseSensitive;
    public final boolean useRegex;
    public final Collection<PropertyDescriptor<?>> descriptors;
    private final Pattern pattern;
    private final String actualValue;
    private final TypeDescriptor[] relationTypes;
    private final Collection<TypeDescriptor> exclude;

    public FilterData(String value, boolean caseSensitive, boolean useRegex, Collection<PropertyDescriptor<?>> descriptors) {
        this(value, caseSensitive, useRegex, descriptors, null, new TypeDescriptor[0]);
    }

    public FilterData(String value, boolean caseSensitive, boolean useRegex, Collection<PropertyDescriptor<?>> descriptors, Collection<TypeDescriptor> exclude, TypeDescriptor ... relationTypes) {
        Assert.isNotNull((Object)value);
        Assert.isTrue((descriptors != null && !descriptors.isEmpty() ? 1 : 0) != 0);
        this.caseSensitive = caseSensitive;
        this.value = value;
        this.actualValue = caseSensitive ? value : value.toLowerCase();
        this.useRegex = useRegex;
        this.pattern = useRegex ? Pattern.compile(value, caseSensitive ? 0 : 2) : null;
        this.descriptors = new ArrayList(descriptors);
        this.relationTypes = relationTypes;
        this.exclude = exclude == null || exclude.isEmpty() ? Collections.emptyList() : exclude;
    }

    public FilterData(String value, FilterData parameters) {
        this(value, parameters.caseSensitive, parameters.useRegex, parameters.descriptors, parameters.exclude, parameters.relationTypes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterData other = (FilterData)obj;
        return this.value.equals(other.value);
    }

    public boolean filter(INode node) {
        String source;
        StringBuilder text = new StringBuilder();
        for (PropertyDescriptor<?> pd : this.descriptors) {
            if (pd == AObject.LABEL) {
                text.append(node.getLabel());
                continue;
            }
            Object v = node.getProperty(pd);
            if (v == null) continue;
            PropertyFormatter pf = PropertyFormatter.getPropetyFormatter((Class)pd.clazz);
            if (pf != null) {
                text.append(pf.toString(v));
                continue;
            }
            text.append(v.toString());
        }
        String string = source = this.caseSensitive ? text.toString() : text.toString().toLowerCase();
        return (!this.useRegex || !this.pattern.matcher(source).find()) && !source.contains(this.actualValue);
    }

    public boolean filter(INodeRelation relation) {
        INode node = relation.getTarget();
        if (!this.filter(node)) {
            return false;
        }
        if (this.exclude.contains(node.getType()) && !this.filter(relation.getSource())) {
            return false;
        }
        for (INodeRelation child : node.getRelations(this.relationTypes)) {
            if (this.filter(child)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean needFilterTo(FilterData other) {
        if (this.useRegex != other.useRegex) {
            return true;
        }
        if (!this.caseSensitive && other.caseSensitive) {
            return true;
        }
        if (!this.value.startsWith(other.value)) {
            return true;
        }
        return !this.descriptors.containsAll(other.descriptors);
    }

    public boolean needUnfilterTo(FilterData other) {
        if (this.useRegex != other.useRegex) {
            return true;
        }
        if (this.caseSensitive && !other.caseSensitive) {
            return true;
        }
        if (!other.value.startsWith(this.value)) {
            return true;
        }
        return !other.descriptors.containsAll(this.descriptors) || !this.descriptors.containsAll(other.descriptors);
    }
}

