/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.utils.StringUtils;

public class LatLng
extends Pos {
    public static final LatLng CENTER = new LatLng(0.0, 0.0);
    private static final double MAX_LNG = 180.0;
    private static final double TOTAL_LNG = 360.0;
    private static final double MAX_LAT = 90.0;
    private static final double TOTAL_LAT = 180.0;

    public static LatLng create(double lat, double lng) {
        if (lat == 0.0 && lng == 0.0) {
            return CENTER;
        }
        return new LatLng(lat, lng);
    }

    public static LatLng create(String s) {
        if (StringUtils.isNullEmptyOrBlank((String)s)) {
            return null;
        }
        String[] values = s.split(",");
        if (values.length != 2) {
            return null;
        }
        try {
            return LatLng.create(Double.parseDouble(values[0]), Double.parseDouble(values[1]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static double bound(double value, double max, double total) {
        double actualValue = value;
        while (actualValue < -max) {
            actualValue += total;
        }
        while (actualValue > max) {
            actualValue -= total;
        }
        return actualValue;
    }

    private LatLng(double lat, double lng) {
        super(LatLng.bound(lng, 180.0, 360.0), LatLng.bound(lat, 90.0, 180.0));
    }

    @Override
    public final String toString() {
        return this.y + "," + this.x;
    }

    @Override
    protected double getEqualsDelta() {
        return 1.0E-5;
    }
}

