/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model;

import com.centreon.studio.client.utils.StringUtils;
import org.eclipse.core.runtime.Assert;

public class Pos {
    public static final Pos NULL = new Pos(0.0, 0.0);
    public final Double x;
    public final Double y;

    public static Pos create(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            return NULL;
        }
        return new Pos(x, y);
    }

    public static Pos create(String s) {
        if (StringUtils.isNullEmptyOrBlank((String)s)) {
            return null;
        }
        String[] values = s.split(",");
        if (values.length != 2) {
            return null;
        }
        try {
            return Pos.create(Double.parseDouble(values[0]), Double.parseDouble(values[1]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static final Pos toRatio(Pos original, Pos max) {
        double r2;
        double r1 = original.x / original.y;
        if (r1 > (r2 = max.x / max.y)) {
            return Pos.create(max.x, max.x / r1);
        }
        return Pos.create(max.y * r1, max.y);
    }

    protected Pos(Double x, Double y) {
        Assert.isNotNull((Object)x);
        Assert.isNotNull((Object)y);
        this.x = x;
        this.y = y;
    }

    public final Pos div(double scale) {
        if (scale == 1.0) {
            return this;
        }
        return Pos.create(this.x / scale, this.y / scale);
    }

    public final Pos div(Pos other) {
        if (other == null) {
            return this;
        }
        return Pos.create(this.x / other.x, this.y / other.y);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pos other = (Pos)obj;
        if (Math.abs(this.x - other.x) > this.getEqualsDelta()) {
            return false;
        }
        return !(Math.abs(this.y - other.y) > this.getEqualsDelta());
    }

    public final int hashCode() {
        int result = 1;
        result = 31 * result + this.x.hashCode();
        result = 31 * result + this.y.hashCode();
        return result;
    }

    public boolean isEmpty() {
        return this.x <= 0.0 || this.y <= 0.0;
    }

    public final Pos minus(double x, double y) {
        return Pos.create(this.x - x, this.y - y);
    }

    public final Pos minus(Pos other) {
        if (other == null) {
            return this;
        }
        return this.minus(other.x, other.y);
    }

    public final Pos mul(double scale) {
        if (scale == 1.0) {
            return this;
        }
        return Pos.create(this.x * scale, this.y * scale);
    }

    public final Pos mul(Pos other) {
        if (other == null) {
            return this;
        }
        return Pos.create(this.x * other.x, this.y * other.y);
    }

    public final Pos plus(double x, double y) {
        return Pos.create(this.x + x, this.y + y);
    }

    public final Pos plus(Pos other) {
        if (other == null) {
            return this;
        }
        return this.plus(other.x, other.y);
    }

    public String toString() {
        return this.x + "," + this.y;
    }

    protected double getEqualsDelta() {
        return 0.1;
    }
}

