/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.utils.StringUtils;
import org.eclipse.swt.graphics.Color;

public class StudioColor {
    private static final int MAX_VALUE = 255;
    public static final StudioColor WHITE = new StudioColor(240, 240, 240);
    public static final StudioColor BLACK = new StudioColor(0, 0, 0);
    public static final StudioColor GREY = new StudioColor(167, 169, 172);
    public static final StudioColor LIGHT_GREY = new StudioColor(220, 220, 220);
    public static final StudioColor RED = new StudioColor(224, 11, 61);
    public static final StudioColor GREEN = new StudioColor(132, 189, 0);
    public static final StudioColor BLUE = new StudioColor(0, 159, 223);
    public static final StudioColor DARK_BLUE = new StudioColor(0, 0, 255);
    public static final StudioColor YELLOW = new StudioColor(255, 154, 19);
    public static final StudioColor CYAN = new StudioColor(0, 255, 255);
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    public static StudioColor fromHexadecimal(String hex) {
        if (hex == null || hex.length() != 7 || hex.charAt(0) != "#".charAt(0)) {
            return null;
        }
        int red = Integer.decode("#" + hex.substring(1, 3));
        int green = Integer.decode("#" + hex.substring(3, 5));
        int blue = Integer.decode("#" + hex.substring(5, 7));
        return new StudioColor(red, green, blue);
    }

    private static int interpolate(int x, int y, double fraction) {
        return Math.max(0, Math.min(255, (int)((double)y - (double)(y - x) * fraction)));
    }

    public StudioColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public StudioColor(int r, int g, int b, int a) {
        if (r > 255 || r < 0 || g > 255 || g < 0 || b > 255 || b < 0 || a > 255 || a < 0) {
            throw new IllegalArgumentException("Provided values must be between 0 and 255");
        }
        this.red = r;
        this.blue = b;
        this.green = g;
        this.alpha = a;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StudioColor other = (StudioColor)obj;
        if (this.alpha != other.alpha) {
            return false;
        }
        if (this.blue != other.blue) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.red == other.red;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    public int getRed() {
        return this.red;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.alpha;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        return result;
    }

    public StudioColor interpolate(StudioColor maxColor, double ratio) {
        int r = StudioColor.interpolate(maxColor.red, this.red, ratio);
        int g = StudioColor.interpolate(maxColor.green, this.green, ratio);
        int b = StudioColor.interpolate(maxColor.blue, this.blue, ratio);
        return new StudioColor(r, g, b);
    }

    public String toHexadecimal() {
        String hexaRed = StringUtils.toHex((int)this.red, (int)2);
        String hexaGreen = StringUtils.toHex((int)this.green, (int)2);
        String hexaBlue = StringUtils.toHex((int)this.blue, (int)2);
        return "#" + hexaRed + hexaGreen + hexaBlue;
    }

    public String toString() {
        return "StudioColor [red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "]";
    }

    public Color toSWT() {
        return StudioRegistries.colorRegistry().getSWTColorFrom(this);
    }
}

