/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import org.eclipse.swt.graphics.Font;

public class StudioFont {
    public static final StudioFont DEFAULT = new StudioFont("Liberation Sans", 10, Style.NORMAL);
    public static final StudioFont SMALL = new StudioFont("Liberation Sans", 8, Style.NORMAL);
    public static final StudioFont BOLD = new StudioFont("Liberation Sans", 10, Style.BOLD);
    private final String name;
    private final int height;
    private final Style style;
    private final String locale;

    public static StudioFont fromFormatedString(String formatedString) {
        String[] inputParts = formatedString.split("#");
        if (inputParts.length != 4) {
            return null;
        }
        String name = inputParts[0];
        String locale = inputParts[1];
        Style style = Style.fromId(Integer.parseInt(inputParts[2]));
        int height = Integer.parseInt(inputParts[3]);
        return new StudioFont(name, height, style, locale);
    }

    public StudioFont(String name, int height, Style style) {
        this(name, height, style, "");
    }

    public StudioFont(String name, int height, Style style, String locale) {
        if (name == null || locale == null || height < 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.locale = locale;
        this.style = style;
        this.height = height;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StudioFont other = (StudioFont)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.style == other.style;
    }

    public int getHeight() {
        return this.height;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public Style getStyle() {
        return this.style;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        return result;
    }

    public String toFormatedString() {
        return String.valueOf(this.name) + "#" + this.locale + "#" + this.style.getId() + "#" + this.height;
    }

    public Font toSWT() {
        return StudioRegistries.fontRegistry().getSWTFontFrom(this);
    }

    public static enum Style {
        NORMAL(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        final int id;

        public static Style fromId(int id) {
            switch (id) {
                case 0: {
                    return NORMAL;
                }
                case 1: {
                    return BOLD;
                }
                case 2: {
                    return ITALIC;
                }
                case 3: {
                    return BOLD_ITALIC;
                }
            }
            throw new IllegalArgumentException();
        }

        private Style(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

