/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.decoration.repository;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.model.decoration.IIndexer;
import com.centreon.studio.client.model.decoration.node.NodeDecorator;
import com.centreon.studio.client.model.decoration.repository.ARepositoryStrategy;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class IndexerRepositoryStrategy
extends ARepositoryStrategy
implements IIndexer {
    private final Collection<TypeDescriptor> ignore = new HashSet<TypeDescriptor>();
    private final Map<TypeDescriptor, Map<Long, INode>> nodes = new HashMap<TypeDescriptor, Map<Long, INode>>();
    private final Map<TypeDescriptor, Map<Long, INodeRelation>> relations = new HashMap<TypeDescriptor, Map<Long, INodeRelation>>();
    private final Map<INode, Collection<INodeRelation>> nodeToRelations = new HashMap<INode, Collection<INodeRelation>>();
    private final boolean allowDuplicates;

    public IndexerRepositoryStrategy(boolean allowDuplicates, TypeDescriptor ... ignore) {
        this.ignore.addAll(Arrays.asList(ignore));
        this.allowDuplicates = allowDuplicates;
    }

    public INode getNode(TypeDescriptor type, Long id) {
        if (type != null) {
            Map<Long, INode> typedNodes = this.nodes.get(type);
            if (typedNodes != null) {
                return typedNodes.get(id);
            }
        } else {
            for (Map<Long, INode> typedNodes : this.nodes.values()) {
                INode node = typedNodes.get(id);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public INodeRelation getRelation(TypeDescriptor type, Long id) {
        if (type != null) {
            Map<Long, INodeRelation> typedRelations = this.relations.get(type);
            if (typedRelations != null) {
                return typedRelations.get(id);
            }
        } else {
            for (Map<Long, INodeRelation> typedRelations : this.relations.values()) {
                INodeRelation relation = typedRelations.get(id);
                if (relation == null) continue;
                return relation;
            }
        }
        return null;
    }

    public Collection<INodeRelation> getRelationsForTarget(INode node) {
        return this.nodeToRelations.get(node);
    }

    public void relationsAdded(NodeDecorator decorator, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            this.index(relation);
        }
    }

    public void relationsRemoved(NodeDecorator decorator, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            this.unindex(relation);
        }
    }

    private void index(INode node) {
        if (!this.ignore.contains(node.getType())) {
            Map<Long, INode> typed = this.nodes.get(node.getType());
            if (typed == null) {
                typed = new HashMap<Long, INode>();
                this.nodes.put(node.getType(), typed);
            }
            INode former = typed.put(node.getId(), node);
            if (!this.allowDuplicates && former != null && former != node && Configuration.DEBUG) {
                System.err.println("indexing a node already present in index : " + node);
            }
        }
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[0])) {
            this.index(relation);
        }
    }

    private void index(INodeRelation relation) {
        if (!this.ignore.contains(relation.getTarget().getType())) {
            Collection<INodeRelation> nodeRelations;
            Map<Long, INodeRelation> typed = this.relations.get(relation.getType());
            if (typed == null) {
                typed = new HashMap<Long, INodeRelation>();
                this.relations.put(relation.getType(), typed);
            }
            INodeRelation former = typed.put(relation.getId(), relation);
            if (!this.allowDuplicates && former != null && former != relation && Configuration.DEBUG) {
                System.err.println("indexing a relation already present in index : " + relation);
            }
            if ((nodeRelations = this.nodeToRelations.get(relation.getTarget())) == null) {
                nodeRelations = new ArrayList<INodeRelation>();
                this.nodeToRelations.put(relation.getTarget(), nodeRelations);
            }
            nodeRelations.add(relation);
        }
        this.index(relation.getTarget());
    }

    private void unindex(INode node) {
        if (!this.ignore.contains(node.getType())) {
            Map<Long, INode> typed = this.nodes.get(node.getType());
            if (typed == null) {
                if (Configuration.DEBUG) {
                    System.err.println("trying to unindex a node of unknown type " + node.getType());
                }
            } else {
                INode former = typed.remove(node.getId());
                if (!this.allowDuplicates && former == null && Configuration.DEBUG) {
                    System.err.println("trying to unindex a node not present in index : " + node);
                }
            }
        }
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[0])) {
            this.unindex(relation);
        }
    }

    private void unindex(INodeRelation relation) {
        if (!this.ignore.contains(relation.getTarget().getType())) {
            Collection<INodeRelation> nodeRelations;
            Map<Long, INodeRelation> typed = this.relations.get(relation.getType());
            if (typed == null) {
                if (Configuration.DEBUG) {
                    System.err.println("trying to unindex a relation of unknown type " + relation.getType());
                }
            } else {
                INodeRelation former = typed.remove(relation.getId());
                if (!this.allowDuplicates && former == null && Configuration.DEBUG) {
                    System.err.println("trying to unindex a relation not present in index : " + relation);
                }
            }
            if ((nodeRelations = this.nodeToRelations.get(relation.getTarget())) != null) {
                this.nodeToRelations.remove(relation.getTarget());
            }
        }
        this.unindex(relation.getTarget());
    }
}

