/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.repository;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.StudioTypes;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertySerializer;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.ARepository;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.IllegalNameException;
import nu.xom.Node;
import nu.xom.Serializer;
import org.eclipse.core.runtime.Assert;

public class XMLRepository
extends ARepository {
    private static final String RELATION = "relation";
    private static final String ID_ATTRIBUTE = "id";
    private static final String TYPE_ATTRIBUTE = "type";
    private final boolean saveLocalProperties;
    private final boolean saveLocalRelations;
    private final Collection<TypeDescriptor> exclude;
    private final File file;
    private final BrokerEventManager eventManager;

    private static INode loadNode(Element element, IRepository repository) {
        Long id = StringUtils.parseLong((String)element.getAttributeValue(ID_ATTRIBUTE), (long)Long.MIN_VALUE);
        int integerType = StringUtils.parseInt((String)element.getAttributeValue(TYPE_ATTRIBUTE));
        TypeDescriptor type = TypeDescriptor.getType((Integer)integerType);
        Collection<PropertyValue> properties = XMLRepository.loadProperties(element);
        INode node = NodeFactories.INSTANCE.create(type, id, properties, repository);
        Elements es = element.getChildElements(RELATION);
        ArrayList<INodeRelation> children = new ArrayList<INodeRelation>(es.size());
        int i = 0;
        while (i < es.size()) {
            children.add(XMLRepository.loadRelation(node, es.get(i)));
            ++i;
        }
        node.addRelations(children);
        return node;
    }

    private static Collection<PropertyValue> loadProperties(Element element) {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(element.getAttributeCount());
        int a = 0;
        while (a < element.getAttributeCount()) {
            PropertyDescriptor pd;
            Attribute attribute = element.getAttribute(a);
            if (attribute != null && (pd = PropertyDescriptor.getPropertyDescriptor((String)attribute.getLocalName())) != null) {
                PropertySerializer ps = PropertySerializer.getPropertySerializer((Class)pd.clazz);
                properties.add(PropertyValue.unchecked((PropertyDescriptor)pd, (Object)ps.toObject(attribute.getValue())));
            }
            ++a;
        }
        return properties;
    }

    private static INodeRelation loadRelation(INode source, Element element) {
        Long id = StringUtils.parseLong((String)element.getAttributeValue(ID_ATTRIBUTE), (long)Long.MIN_VALUE);
        int integerType = StringUtils.parseInt((String)element.getAttributeValue(TYPE_ATTRIBUTE));
        TypeDescriptor type = TypeDescriptor.getType((Integer)integerType);
        Collection<PropertyValue> properties = XMLRepository.loadProperties(element);
        Element child = element.getFirstChildElement("node");
        INode target = XMLRepository.loadNode(child, source.getRepository());
        return NodeRelationFactories.INSTANCE.create(type, id, source, target, properties);
    }

    public XMLRepository(File file, BrokerEventManager eventManager) {
        this("XMLRepository", file, eventManager);
    }

    public XMLRepository(String label, File file, boolean saveLocalProperties, boolean saveLocalRelations, BrokerEventManager eventManager, TypeDescriptor ... exclude) {
        super(StudioTypes.REPOSITORY, label);
        this.saveLocalProperties = saveLocalProperties;
        this.saveLocalRelations = saveLocalRelations;
        this.eventManager = eventManager;
        this.exclude = Arrays.asList(exclude);
        this.file = file;
        Assert.isNotNull((Object)file);
    }

    protected XMLRepository(String label, File file, BrokerEventManager eventManager) {
        this(label, file, true, true, eventManager, new TypeDescriptor[0]);
    }

    @PostConstruct
    public void load() throws Exception {
        if (!this.file.exists() || this.file.length() == 0L) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream inputStream = new FileInputStream(this.file);){
            Builder parser = new Builder();
            Document doc = parser.build((InputStream)inputStream);
            Element root = doc.getRootElement();
            Elements es = root.getChildElements(RELATION);
            ArrayList<INodeRelation> children = new ArrayList<INodeRelation>(es.size());
            int i = 0;
            while (i < es.size()) {
                children.add(XMLRepository.loadRelation((INode)this, es.get(i)));
                ++i;
            }
            this.addRelations(children);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @PreDestroy
    public void save() throws IOException {
        if (this.getRelations(new TypeDescriptor[0]).isEmpty()) {
            this.file.delete();
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileOutputStream outputStream = new FileOutputStream(this.file);){
            Element root = new Element("repository");
            for (INodeRelation relation : this.getRelations(new TypeDescriptor[0])) {
                if (relation.getType().isLocal() && !this.saveLocalRelations) continue;
                this.saveRelation(relation, root);
            }
            Serializer serializer = new Serializer((OutputStream)outputStream);
            serializer.setIndent(2);
            serializer.write(new Document(root));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void saveNode(INode node, Element parent) {
        Element element = new Element("node");
        this.saveObject((IObject)node, element);
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[0])) {
            if (relation.getType().isLocal() && !this.saveLocalRelations || this.exclude.contains(relation.getType())) continue;
            this.saveRelation(relation, element);
        }
        parent.appendChild((Node)element);
    }

    private void saveObject(IObject object, Element element) {
        element.addAttribute(new Attribute(ID_ATTRIBUTE, object.getId().toString()));
        element.addAttribute(new Attribute(TYPE_ATTRIBUTE, object.getType().getId().toString()));
        for (PropertyValue p : object.getPropertyValues()) {
            Class propertyClazz;
            PropertySerializer ps;
            if (p.getProperty().isLocal && !this.saveLocalProperties || (ps = PropertySerializer.getPropertySerializer((Class)(propertyClazz = p.getProperty().clazz))) == null) continue;
            try {
                Attribute attribute = new Attribute(p.getProperty().id, ps.toString(p.getValue()));
                element.addAttribute(attribute);
            }
            catch (IllegalNameException illegalNameException) {
                if (this.eventManager == null) continue;
                this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Skipped attribute containing illegal char for element={}, key={}, value={}", (Object[])new Object[]{object.getLabel(), p.getProperty().id, ps.toString(p.getValue())}));
            }
        }
    }

    private void saveRelation(INodeRelation relation, Element parent) {
        Element element = new Element(RELATION);
        this.saveObject((IObject)relation, element);
        this.saveNode(relation.getTarget(), element);
        parent.appendChild((Node)element);
    }
}

