/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.sync;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.Scheduler;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.sync.SyncEvent;
import com.centreon.studio.client.sync.SyncWebService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class SyncAddon
extends AuthenticationEventHandler {
    private final BrokerEventManager eventManager;
    private final SyncWebService service;
    private final Scheduler scheduler;
    private volatile ScheduledFuture<?> synchroDaemon;

    @Inject
    public SyncAddon(BrokerEventManager eventManager, SyncWebService service, Scheduler scheduler) {
        this.eventManager = eventManager;
        this.scheduler = scheduler;
        this.service = service;
    }

    @PostConstruct
    public void postConstruct() {
        this.eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Sync addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy() {
        this.eventManager.unsubscribe((StudioEventHandler)this);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Sync addon destroyed", (Object[])new Object[0]));
    }

    protected void doQuit() {
        if (this.synchroDaemon != null) {
            this.synchroDaemon.cancel(false);
        }
    }

    protected void loggedIn() {
        this.synchroDaemon = this.scheduler.scheduleAtFixedRate(() -> {
            try {
                for (SyncEvent event : this.service.getEvents()) {
                    this.eventManager.async((StudioEvent)event);
                }
            }
            catch (Exception exception) {}
        }, 0L, (long)Configuration.SYNC_DELAY, TimeUnit.MILLISECONDS);
    }

    protected void loggedOut() {
        if (this.synchroDaemon != null) {
            this.synchroDaemon.cancel(false);
        }
    }
}

