/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.sync;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.cxf.AWebService;
import com.centreon.studio.client.events.sync.SyncEvent;
import com.centreon.studio.map.commons.PropertyDto;
import com.centreon.studio.map.sync.EventDto;
import com.centreon.studio.map.syncservice.SyncPortType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SyncWebService
extends AWebService<SyncPortType> {
    @Inject
    public SyncWebService() {
        super("/centreon-studio/services/sync?wsdl", SyncPortType.class, !Configuration.SKIP_GZIP);
    }

    public Collection<SyncEvent> getEvents() {
        if (!this.isInit()) {
            return Collections.emptyList();
        }
        List eventListDto = ((SyncPortType)this.service).getEventList();
        if (eventListDto.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap typeToActionToData = new HashMap();
        for (EventDto eventDto : eventListDto) {
            HashSet<SyncEvent.SyncData> datas;
            HashMap actionToData = (HashMap)typeToActionToData.get(eventDto.getSourceType());
            if (actionToData == null) {
                actionToData = new HashMap();
                typeToActionToData.put(eventDto.getSourceType(), actionToData);
            }
            if ((datas = (HashSet<SyncEvent.SyncData>)actionToData.get(eventDto.getEventType())) == null) {
                datas = new HashSet<SyncEvent.SyncData>();
                actionToData.put(eventDto.getEventType(), datas);
            }
            SyncEvent.SyncData data = new SyncEvent.SyncData(Long.valueOf(eventDto.getSourceId()));
            for (PropertyDto property : eventDto.getProperties()) {
                data.setProperty(property.getKey(), (Object)property.getValue());
            }
            datas.add(data);
        }
        ArrayList<SyncEvent> events = new ArrayList<SyncEvent>(typeToActionToData.size() * 3);
        for (Map.Entry entry1 : typeToActionToData.entrySet()) {
            for (Map.Entry entry : ((Map)entry1.getValue()).entrySet()) {
                SyncEvent.SyncAction action = SyncEvent.SyncAction.fromString((String)((String)entry.getKey()));
                if (action == null) continue;
                events.add(new SyncEvent(action, (Integer)entry1.getKey(), (Collection)entry.getValue()));
            }
        }
        return events;
    }
}

