/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.zest;

import com.centreon.studio.client.zest.ZestModel;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;

public enum ZestLayout {
    TREE(1L, "Tree", (LayoutAlgorithm)new TreeLayoutAlgorithm(1)),
    HTREE(2L, "Horizontal Tree", (LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1)),
    GRID(3L, "Grid", (LayoutAlgorithm)new GridLayoutAlgorithm(1)),
    RADIAL(4L, "Radial", (LayoutAlgorithm)new RadialLayoutAlgorithm(1)),
    SPRING(5L, "Spring", (LayoutAlgorithm)new SpringLayoutAlgorithm(1));

    private static final int MARGIN = 25;
    private final Long id;
    private final String label;
    private final LayoutAlgorithm algo;

    private ZestLayout(Long id, String label, LayoutAlgorithm algo) {
        this.id = id;
        this.label = label;
        this.algo = algo;
    }

    public Long getId() {
        return this.id;
    }

    public void layout(ZestModel model, double width, double height) {
        try {
            this.algo.applyLayout((LayoutEntity[])model.getEntities(), (LayoutRelationship[])model.getRelationships(), 25.0, 25.0, width - 25.0, height - 25.0, false, false);
            model.apply();
        }
        catch (InvalidLayoutConfiguration e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.label;
    }
}

