/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.chart;

import com.centreon.studio.client.commons.threads.GraphicalThreadDelayer;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ChartComposite
extends Composite
implements PaintListener,
ICallBackNotifier,
ControlListener,
Runnable {
    private Chart chart;
    private GraphicalThreadDelayer thread;
    private IDeviceRenderer renderer;
    private GeneratedChartState chartState;
    private boolean needsGeneration = true;

    public ChartComposite(Composite parent, Chart chart) {
        this(parent, chart, null);
    }

    public ChartComposite(Composite parent, Chart chart, PlatformConfig config) {
        super(parent, 0);
        this.setBackground(parent.getBackground());
        this.chart = chart;
        try {
            this.renderer = PluginSettings.instance((PlatformConfig)config).getDevice("dv.SWT");
            this.renderer.setProperty("device.component", (Object)this);
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.addPaintListener(this);
        this.addControlListener(this);
    }

    public void callback(Object event, Object source, CallBackValue value) {
        if (this.chart instanceof ICallBackNotifier) {
            ((ICallBackNotifier)this.chart).callback(event, source, value);
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.regenerateChart();
    }

    public Chart getDesignTimeModel() {
        return this.chart;
    }

    public Chart getRunTimeModel() {
        return this.chartState.getChartModel();
    }

    public void paintControl(PaintEvent e) {
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new GraphicalThreadDelayer((Runnable)this, true, 100);
            this.thread.start();
        } else {
            this.thread.requireRedelay();
        }
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.needsGeneration = true;
        this.repaintChart();
    }

    public void repaintChart() {
        this.redraw();
    }

    @Override
    public void run() {
        if (!this.isDisposed() && this.chart != null) {
            Rectangle d = this.getClientArea();
            Image imgChart = new Image((Device)this.getDisplay(), d);
            GC gcImage = new GC((Drawable)imgChart);
            GC gcComposite = new GC((Drawable)this);
            try {
                try {
                    this.renderer.setProperty("device.output.context", (Object)gcImage);
                    Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)d.width, (double)d.height);
                    bo.scale(72.0 / (double)this.renderer.getDisplayServer().getDpiResolution());
                    Generator generator = Generator.instance();
                    if (this.needsGeneration) {
                        this.chartState = generator.build(this.renderer.getDisplayServer(), this.chart, bo, null, null, null);
                        this.needsGeneration = false;
                    }
                    generator.render(this.renderer, this.chartState);
                    gcComposite.drawImage(imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    ce.printStackTrace();
                    gcImage.dispose();
                    gcComposite.dispose();
                }
            }
            finally {
                gcImage.dispose();
                gcComposite.dispose();
            }
        }
    }

    public void setChart(Chart chart) {
        this.chart = chart;
        this.regenerateChart();
    }
}

