/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.chart;

import com.centreon.studio.client.chart.LineData;
import com.centreon.studio.client.model.ListOfMetricLine;
import com.centreon.studio.client.model.MetricLine;
import com.centreon.studio.client.utils.CollectionsUtils;
import com.centreon.studio.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.PaletteImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;

public class LinesChart
extends ChartWithAxesImpl {
    public static final String VERDANA = "Verdana";
    private final Axis xAxis;
    private final List<LineData> lines = new ArrayList<LineData>(10);
    private boolean fill;
    private int alpha;
    private boolean stack;
    private Axis yAxis1;
    private Axis yAxis2;
    private long[] dates;
    private boolean showGrid;
    private int markerSize;
    private MarkerType markerStyle;
    private boolean showThreshold;

    private static void customizeAxis(Axis axis, Position position, TickStyle style, AxisType type, IntersectionType origin) {
        axis.setType(type);
        axis.getLabel().getCaption().getFont().setSize(10.0f);
        axis.getLabel().getCaption().setColor(ColorDefinitionImpl.GREY());
        axis.getLabel().getCaption().getFont().setName(VERDANA);
        axis.getMajorGrid().getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
        axis.getMajorGrid().getLineAttributes().setColor(ColorDefinitionImpl.GREY());
        axis.getMajorGrid().setTickStyle(style);
        if (origin != null) {
            axis.getOrigin().setType(origin);
        }
        if (position != null) {
            axis.setLabelPosition(position);
            axis.setTitlePosition(position);
            axis.getTitle().setVisible(true);
            axis.getTitle().getCaption().getFont().setSize(8.0f);
        }
    }

    private static void fillYAxis(Axis axis, Collection<LineSeries> series, String unit) {
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        seriesDefinition.setSeriesPalette(PaletteImpl.create((int)0, (boolean)true));
        axis.getTitle().getCaption().setValue(unit);
        for (LineSeries serie : series) {
            ColorDefinition color = serie.getLineAttributes().getColor().copyInstance();
            seriesDefinition.getSeriesPalette().getEntries().add((Object)color);
            seriesDefinition.getSeries().add((Object)serie);
        }
        axis.getSeriesDefinitions().add((Object)seriesDefinition);
        LinesChart.setVisible(axis, true);
    }

    private static String getIdentifier(String label, String unit) {
        if (StringUtils.isNullEmptyOrBlank((String)unit)) {
            return label;
        }
        return String.valueOf(label) + " " + unit;
    }

    private static void setVisible(Axis axis, boolean showAxises) {
        if (axis == null) {
            return;
        }
        axis.getLabel().setVisible(showAxises);
        axis.getTitle().setVisible(showAxises);
        axis.getLineAttributes().setVisible(showAxises);
        axis.getMinorGrid().getLineAttributes().setVisible(showAxises);
        axis.getMinorGrid().getTickAttributes().setVisible(showAxises);
        axis.getMajorGrid().getLineAttributes().setVisible(showAxises);
        axis.getMajorGrid().getTickAttributes().setVisible(showAxises);
        for (MarkerLine marker : axis.getMarkerLines()) {
            marker.getLineAttributes().setVisible(showAxises);
            marker.getLabel().setVisible(showAxises);
        }
    }

    public LinesChart() {
        this.initDefault();
        this.getLegend().getText().getFont().setSize(10.0f);
        this.getLegend().setPosition(Position.BELOW_LITERAL);
        this.getLegend().setOrientation(Orientation.HORIZONTAL_LITERAL);
        this.xAxis = this.getPrimaryBaseAxes()[0];
        this.xAxis.setInterval(3);
        this.xAxis.setFormatSpecifier((FormatSpecifier)JavaDateFormatSpecifierImpl.create((String)"E HH:mm"));
        LinesChart.customizeAxis(this.xAxis, null, TickStyle.BELOW_LITERAL, AxisType.DATE_TIME_LITERAL, IntersectionType.MIN_LITERAL);
        this.yAxis1 = this.getPrimaryOrthogonalAxis(this.xAxis);
        LinesChart.customizeAxis(this.yAxis1, Position.LEFT_LITERAL, TickStyle.LEFT_LITERAL, AxisType.LINEAR_LITERAL, IntersectionType.VALUE_LITERAL);
        this.getTitle().setVisible(false);
    }

    private LineSeries createLineSerie(LineData lineData, MetricLine metricLine) {
        ColorDefinition color = lineData.getColor();
        MarkerType style = this.markerStyle;
        int size = this.markerSize;
        if (metricLine != null) {
            String[] colorSplit = metricLine.getColor().split(":");
            color = ColorDefinitionImpl.create((int)Integer.valueOf(colorSplit[0]), (int)Integer.valueOf(colorSplit[1]), (int)Integer.valueOf(colorSplit[2]), (int)this.alpha);
            style = MarkerType.getByName((String)metricLine.getStyle());
            size = metricLine.getSize();
        }
        LineSeries lineSeries = (LineSeries)(this.fill && !lineData.isThreshold() ? AreaSeriesImpl.create() : LineSeriesImpl.create());
        lineSeries.setSeriesIdentifier((Object)LinesChart.getIdentifier(lineData.getLabel(), lineData.getUnit()));
        lineSeries.setDataSet((DataSet)NumberDataSetImpl.create(lineData.getValues()));
        lineSeries.getLineAttributes().setThickness(lineData.isThreshold() ? 1 : 2);
        lineSeries.getLineAttributes().setColor(color.copyInstance());
        lineSeries.getLineAttributes().setStyle(!lineData.isThreshold() ? LineStyle.SOLID_LITERAL : LineStyle.DASH_DOTTED_LITERAL);
        lineSeries.setStacked(!lineData.isThreshold() && this.stack);
        lineSeries.setPaletteLineColor(false);
        for (Marker marker : lineSeries.getMarkers()) {
            marker.setSize(size);
            marker.setType(style);
        }
        return lineSeries;
    }

    private Map<String, Collection<LineSeries>> fillLineData(ListOfMetricLine listOfMetricLines, List<LineData> lines) {
        int criticalSize;
        Map lineSeries = CollectionsUtils.createMultiMap((int)1, ArrayList.class);
        Map warningThreshold = CollectionsUtils.createMultiMap((int)1, ArrayList.class);
        Map criticalThreshold = CollectionsUtils.createMultiMap((int)1, ArrayList.class);
        for (LineData lineData : lines) {
            boolean display;
            MetricLine metricLine = listOfMetricLines.stream().filter(e -> e.getLabel().equals(lineData.getLabel())).findAny().orElse(null);
            boolean bl = display = metricLine == null || metricLine.isVisible();
            if (!this.showThreshold && lineData.isThreshold() || !display) continue;
            LineSeries serie = this.createLineSerie(lineData, metricLine);
            if (lineData.isThreshold()) {
                if ("Critical".equals(lineData.getLabel())) {
                    ((Collection)criticalThreshold.get(lineData.getUnit())).add(serie);
                    continue;
                }
                if (!"Warning".equals(lineData.getLabel())) continue;
                ((Collection)warningThreshold.get(lineData.getUnit())).add(serie);
                continue;
            }
            ((Collection)lineSeries.get(lineData.getUnit())).add(serie);
        }
        int warningSize = warningThreshold.values().stream().mapToInt(Collection::size).sum();
        if (warningSize == 1) {
            warningThreshold.entrySet().stream().forEach(e -> {
                boolean bl = ((Collection)lineSeries.get(e.getKey())).addAll((Collection)e.getValue());
            });
        }
        if ((criticalSize = criticalThreshold.values().stream().mapToInt(Collection::size).sum()) == 1) {
            criticalThreshold.entrySet().stream().forEach(e -> {
                boolean bl = ((Collection)lineSeries.get(e.getKey())).addAll((Collection)e.getValue());
            });
        }
        return lineSeries;
    }

    public final void refreshLines(ListOfMetricLine listOfMetricLines) {
        this.updateDates();
        this.yAxis1.getSeriesDefinitions().clear();
        if (this.yAxis2 != null) {
            this.xAxis.getAssociatedAxes().remove((Object)this.yAxis2);
            this.yAxis2.getSeriesDefinitions().clear();
        }
        SeriesDefinition seriesDefinition1 = SeriesDefinitionImpl.create();
        seriesDefinition1.setSeriesPalette(PaletteImpl.create((int)0, (boolean)true));
        SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
        seriesDefinition2.setSeriesPalette(PaletteImpl.create((int)0, (boolean)true));
        Map<String, Collection<LineSeries>> lineSeries = this.fillLineData(listOfMetricLines, this.lines);
        if (lineSeries.size() > 2) {
            Collection mergedSeries = lineSeries.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            lineSeries.clear();
            lineSeries.put("", mergedSeries);
        }
        int index = 0;
        for (Map.Entry<String, Collection<LineSeries>> entry : lineSeries.entrySet()) {
            String unit = entry.getKey();
            if (index == 0) {
                this.yAxis1 = this.getPrimaryOrthogonalAxis(this.xAxis);
                LinesChart.fillYAxis(this.yAxis1, entry.getValue(), unit);
                this.xAxis.getAssociatedAxes().add((Object)this.yAxis1);
                LinesChart.customizeAxis(this.yAxis1, Position.LEFT_LITERAL, TickStyle.LEFT_LITERAL, AxisType.LINEAR_LITERAL, IntersectionType.VALUE_LITERAL);
            } else {
                this.yAxis2 = AxisImpl.create((int)2);
                LinesChart.fillYAxis(this.yAxis2, entry.getValue(), unit);
                this.xAxis.getAssociatedAxes().add((Object)this.yAxis2);
                LinesChart.customizeAxis(this.yAxis2, Position.RIGHT_LITERAL, TickStyle.RIGHT_LITERAL, AxisType.LINEAR_LITERAL, null);
            }
            ++index;
        }
        this.updateShowGrid();
    }

    public final LinesChart setAlpha(int alpha) {
        this.alpha = alpha;
        return this;
    }

    public void setAxesFontSize(int fontSize) {
        this.xAxis.getLabel().getCaption().getFont().setSize((float)fontSize);
        this.yAxis1.getLabel().getCaption().getFont().setSize((float)fontSize);
        if (this.yAxis2 != null) {
            this.yAxis2.getLabel().getCaption().getFont().setSize((float)fontSize);
        }
    }

    public final LinesChart setDates(long[] dates) {
        this.dates = dates;
        return this;
    }

    public final LinesChart setFill(boolean fill) {
        this.fill = fill;
        return this;
    }

    public void setLegendFontSize(int fontSize) {
        this.getLegend().getText().getFont().setSize((float)fontSize);
    }

    public final LinesChart setLines(List<LineData> lines) {
        this.lines.clear();
        this.lines.addAll(lines);
        return this;
    }

    public final LinesChart setMarkerSize(int markerSize) {
        this.markerSize = markerSize;
        return this;
    }

    public final LinesChart setMarkerStyle(String markerStyle) {
        this.markerStyle = MarkerType.getByName((String)markerStyle);
        return this;
    }

    public final LinesChart setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
        return this;
    }

    public final LinesChart setShowThreshold(boolean showThreshold) {
        this.showThreshold = showThreshold;
        return this;
    }

    public final LinesChart setStack(boolean stack) {
        this.stack = stack;
        return this;
    }

    public final LinesChart setTitle(String title) {
        this.getTitle().getLabel().getCaption().setValue(title);
        this.getTitle().getLabel().getCaption().getFont().setSize(10.0f);
        this.getTitle().setVisible(!StringUtils.isNullEmptyOrBlank((String)title));
        return this;
    }

    public void setTitleFontSize(int fontSize) {
        this.getTitle().getLabel().getCaption().getFont().setSize((float)fontSize);
    }

    private void updateDates() {
        Series xSeries = SeriesImpl.create();
        xSeries.setDataSet((DataSet)DateTimeDataSetImpl.create((Object)this.dates));
        SeriesDefinition xSeriesDefinition = SeriesDefinitionImpl.create();
        xSeriesDefinition.getSeries().add((Object)xSeries);
        this.xAxis.getSeriesDefinitions().clear();
        this.xAxis.getSeriesDefinitions().add((Object)xSeriesDefinition);
    }

    private final void updateShowGrid() {
        this.xAxis.getMajorGrid().getLineAttributes().setVisible(this.showGrid);
        this.yAxis1.getMajorGrid().getLineAttributes().setVisible(this.showGrid);
        this.yAxis1.getMinorGrid().getLineAttributes().setVisible(false);
        if (this.yAxis2 != null) {
            this.yAxis2.getMajorGrid().getLineAttributes().setVisible(this.showGrid);
            this.yAxis2.getMinorGrid().getLineAttributes().setVisible(false);
        }
    }
}

