/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.acl.ACLUtils;
import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.SeparatorAction;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actions.common.StudioActionGroup;
import com.centreon.studio.client.model.ui.actionsets.ActionSetContributor;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.map.client.elements.model.repository.decorators.ElementRepositoryDecorator;
import com.centreon.studio.map.client.elements.model.ui.actionsets.ElementEditorActionSetDescriptor;
import com.centreon.studio.map.client.elements.monitoring.messages.MonitoringMessages;
import com.centreon.studio.map.client.elements.monitoring.model.MonitoringTypes;
import com.centreon.studio.map.client.elements.monitoring.model.repository.CommandRepositoryDecorator;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.AddAcknowledgementAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.AddDowntimeAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.CentreonConfigurationAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.CentreonMonitoringAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.CentreonURLAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.CentreonWebClientAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.DisableCheckAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.DisableNotificationAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.EnableCheckAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.EnableNotificationAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.ForceCheckAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.RemoveAcknowledgementAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.RemoveDowntimeAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.ScheduleCheckAction;
import com.centreon.studio.map.client.resources.model.ResourcePropertyDescriptors;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class MonitoringAddon
extends AuthenticationEventHandler
implements ActionSetContributor {
    private final IRepository commandRepository;

    @Inject
    public MonitoringAddon(CommandRepositoryDecorator repository, ACLUtils utils) {
        this.commandRepository = repository;
        ActionSetDescriptor.contribute(ElementEditorActionSetDescriptor.class, (ActionSetContributor)this);
        for (TypeDescriptor type : MonitoringTypes.getAll()) {
            utils.register(type);
        }
    }

    public void contribute(List<StudioAction> actions, IEclipseContext context) {
        IRepository elementRepository = (IRepository)ContextInjectionFactory.make(ElementRepositoryDecorator.class, (IEclipseContext)context);
        StudioActionGroup monitoringGroup = new StudioActionGroup(MonitoringMessages.monitoring);
        monitoringGroup.addAction((StudioAction)new AddAcknowledgementAction(elementRepository, this.commandRepository, context));
        monitoringGroup.addAction((StudioAction)new RemoveAcknowledgementAction(elementRepository, this.commandRepository, context));
        monitoringGroup.addAction((StudioAction)SeparatorAction.INSTANCE);
        monitoringGroup.addAction((StudioAction)new AddDowntimeAction(elementRepository, this.commandRepository, context));
        monitoringGroup.addAction((StudioAction)new RemoveDowntimeAction(elementRepository, this.commandRepository, context));
        monitoringGroup.addAction((StudioAction)SeparatorAction.INSTANCE);
        monitoringGroup.addAction((StudioAction)new ScheduleCheckAction(elementRepository, this.commandRepository, context));
        monitoringGroup.addAction((StudioAction)new ForceCheckAction(elementRepository, this.commandRepository, context));
        monitoringGroup.addAction((StudioAction)SeparatorAction.INSTANCE);
        monitoringGroup.addAction((StudioAction)new EnableCheckAction(elementRepository, this.commandRepository, context));
        monitoringGroup.addAction((StudioAction)new DisableCheckAction(elementRepository, this.commandRepository, context));
        monitoringGroup.addAction((StudioAction)SeparatorAction.INSTANCE);
        monitoringGroup.addAction((StudioAction)new EnableNotificationAction(elementRepository, this.commandRepository, context));
        monitoringGroup.addAction((StudioAction)new DisableNotificationAction(elementRepository, this.commandRepository, context));
        actions.add((StudioAction)monitoringGroup);
        IEclipseContext topContext = ContextUtils.getTopContext((IEclipseContext)context);
        ACLUser user = (ACLUser)topContext.get(ACLUser.class);
        StudioActionGroup centreonGroup = new StudioActionGroup(MonitoringMessages.centreonWeb);
        centreonGroup.addAction((StudioAction)new CentreonConfigurationAction(elementRepository, user));
        centreonGroup.addAction((StudioAction)new CentreonMonitoringAction(elementRepository, user));
        centreonGroup.addAction((StudioAction)new CentreonWebClientAction(elementRepository, user));
        centreonGroup.addAction((StudioAction)new CentreonURLAction(elementRepository, user, (PropertyDescriptor<String>)ResourcePropertyDescriptors.NOTES_URL));
        centreonGroup.addAction((StudioAction)new CentreonURLAction(elementRepository, user, (PropertyDescriptor<String>)ResourcePropertyDescriptors.ACTION_URL));
        actions.add((StudioAction)centreonGroup);
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager) {
        eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Monitoring addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        eventManager.unsubscribe((StudioEventHandler)this);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Monitoring addon destroyed", (Object[])new Object[0]));
    }

    protected void loggedOut() {
        this.clearCommandRepository();
    }

    private void clearCommandRepository() {
        IRepository undecoratedRepository = (IRepository)this.commandRepository.adapt(IRepository.class);
        undecoratedRepository.setSelection((Object)this, null);
        undecoratedRepository.removeRelations((Collection)undecoratedRepository.getRelations(new TypeDescriptor[0]));
    }
}

