/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring.model.ui.actions;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.acl.ACLUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.WizardFactories;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.monitoring.model.MonitoringPropertyDescriptors;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public abstract class AMonitoringAction
extends AACLRepositoryAction {
    protected static final Collection<TypeDescriptor> COMMANDABLE_TYPES = Arrays.asList(ElementTypes.ELEMENT_HOST, ElementTypes.ELEMENT_SERVICE);
    protected final IRepository commandRepository;
    private final IEclipseContext context;

    protected AMonitoringAction(String text, IRepository input, IRepository commandRepository, IEclipseContext context) {
        super(text, input);
        this.setSelectionMultiAccepted(true);
        this.setSelectionSingleAccepted(true);
        this.setACLRightNeeded(ACLPropertyDescriptors.CAN_READ);
        this.addSupportedTypes(ElementTypes.getAllMonitoredElements());
        this.commandRepository = commandRepository;
        this.context = context;
    }

    public final boolean customIsEnabled() {
        ACLUtils utils = (ACLUtils)ContextInjectionFactory.make(ACLUtils.class, (IEclipseContext)this.context);
        if (!utils.can(this.aclRightNeeded, this.getType(), null, true).booleanValue()) {
            return false;
        }
        for (INodeRelation relation : this.getInput().getSelections()) {
            if (!this.isRecursiveFlagged(relation.getTarget())) continue;
            return true;
        }
        return false;
    }

    protected void addToRepository(List<INodeRelation> commandRelations) {
        for (INodeRelation commandRelation : commandRelations) {
            INode element = commandRelation.getSource();
            INode command = commandRelation.getTarget();
            command.addPropertyValue(PropertyDescriptors.SCOPE, (Object)element);
            INodeRelation relation = NodeRelationFactories.INSTANCE.create((INode)this.commandRepository, command);
            this.commandRepository.addRelation(relation);
        }
    }

    protected void createRecursiveCommands(INode source, INodeRelation command, List<INodeRelation> commands) {
        for (INodeRelation relation : source.getRelations(new TypeDescriptor[]{ElementTypes.RELATION_HIERARCHY, ElementTypes.RELATION_HIERARCHY_GRAPHIC})) {
            if (COMMANDABLE_TYPES.contains(relation.getTarget().getType()) && this.isFlagged(relation.getTarget()).booleanValue()) {
                commands.add(INodeUtils.copy((INodeRelation)command, (INode)relation.getTarget(), (boolean)false, (boolean)true, (IRepository)this.commandRepository, (PropertyValue[])new PropertyValue[0]));
            }
            this.createRecursiveCommands(relation.getTarget(), command, commands);
        }
    }

    protected abstract TypeDescriptor getType();

    protected final IUndoHandler internalRun() {
        List<INodeRelation> elementToCommands = this.createCommands(this.getType());
        INodeRelation input = elementToCommands.get(0);
        CustomWizardDialog dialog = WizardFactories.INSTANCE.createDialog(input, this.context);
        if (dialog == null || dialog.open() == 0) {
            input = dialog == null ? input : (INodeRelation)dialog.getInput().iterator().next();
            for (INodeRelation elementToCommand : elementToCommands) {
                INodeUtils.performDelta((INode)elementToCommand.getTarget(), (INode)input.getTarget());
                if (!((Boolean)elementToCommand.getTarget().getProperty(MonitoringPropertyDescriptors.RECURSIVE)).booleanValue()) continue;
                this.createRecursiveCommands(elementToCommand.getSource(), elementToCommand, elementToCommands);
            }
            this.addToRepository(elementToCommands);
        }
        return null;
    }

    protected abstract Boolean isFlagged(INode var1);

    private List<INodeRelation> createCommands(TypeDescriptor type) {
        CopyOnWriteArrayList<INodeRelation> commands = new CopyOnWriteArrayList<INodeRelation>();
        for (INodeRelation selection : this.getInput().getSelections()) {
            INode command = NodeFactories.INSTANCE.create(type, SequenceUtils.next(), null, this.commandRepository);
            commands.add(NodeRelationFactories.INSTANCE.create(selection.getTarget(), command));
        }
        return commands;
    }

    private boolean isRecursiveFlagged(INode node) {
        if (this.isFlagged(node).booleanValue()) {
            return true;
        }
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[]{ElementTypes.RELATION_HIERARCHY})) {
            if (!this.isRecursiveFlagged(relation.getTarget())) continue;
            return true;
        }
        return false;
    }
}

