/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring.model.ui.actions;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.monitoring.messages.MonitoringMessages;
import com.centreon.studio.map.client.elements.monitoring.model.CentreonPropertyDescriptors;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.ACentreonAction;
import com.centreon.studio.map.client.elements.monitoring.model.ui.actions.StudioId;
import com.centreon.studio.map.client.resources.bam.model.BAMResourceTypes;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CentreonConfigurationAction
extends ACentreonAction {
    private static final Map<TypeDescriptor, PropertyDescriptor<String>> TYPE_TO_PROPERTY = new HashMap<TypeDescriptor, PropertyDescriptor<String>>();

    static {
        TYPE_TO_PROPERTY.put(ResourceTypes.RESOURCE_HOST, CentreonPropertyDescriptors.URL_CONF_HOST);
        TYPE_TO_PROPERTY.put(ResourceTypes.RESOURCE_SERVICE, CentreonPropertyDescriptors.URL_CONF_SERVICE);
        TYPE_TO_PROPERTY.put(ResourceTypes.RESOURCE_HOST_GROUP, CentreonPropertyDescriptors.URL_CONF_HOSTGROUP);
        TYPE_TO_PROPERTY.put(ResourceTypes.RESOURCE_SERVICE_GROUP, CentreonPropertyDescriptors.URL_CONF_SERVICEGROUP);
        TYPE_TO_PROPERTY.put(ResourceTypes.RESOURCE_SERVICE_META, CentreonPropertyDescriptors.URL_CONF_SERVICEMETA);
        TYPE_TO_PROPERTY.put(BAMResourceTypes.RESOURCE_BA, CentreonPropertyDescriptors.URL_CONF_BA);
        TYPE_TO_PROPERTY.put(BAMResourceTypes.RESOURCE_KPI_BA, CentreonPropertyDescriptors.URL_CONF_KPI);
        TYPE_TO_PROPERTY.put(BAMResourceTypes.RESOURCE_KPI_META, CentreonPropertyDescriptors.URL_CONF_KPI);
        TYPE_TO_PROPERTY.put(BAMResourceTypes.RESOURCE_KPI_BOOLEAN, CentreonPropertyDescriptors.URL_CONF_KPI);
        TYPE_TO_PROPERTY.put(BAMResourceTypes.RESOURCE_KPI_SERVICE, CentreonPropertyDescriptors.URL_CONF_KPI);
    }

    public CentreonConfigurationAction(IRepository repository, ACLUser user) {
        super(MonitoringMessages.configurationPage, repository, user, Collections.emptyList());
    }

    protected final String getImageDescriptorPath() {
        return ResourceTypes.RESOURCES.getSmallImage();
    }

    @Override
    protected String getSuffix(INodeRelation relation) {
        INode target = relation.getTarget();
        PropertyDescriptor<String> desc = TYPE_TO_PROPERTY.get(target.getProperty(ElementPropertyDescriptors.RESOURCE_TYPE));
        if (desc == null) {
            return null;
        }
        String url = (String)this.user.getProperty(desc);
        if (StringUtils.isNullEmptyOrBlank((String)url)) {
            return null;
        }
        long id = (Long)target.getProperty(ElementPropertyDescriptors.RESOURCE_ID);
        long actualId = target.getType() == ElementTypes.ELEMENT_SERVICE ? (long)StudioId.unmergeService(id) : id;
        return url.replaceAll(ACentreonAction.macro(ElementPropertyDescriptors.RESOURCE_ID), String.valueOf(actualId));
    }
}

