/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs;

import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.dialogs.CustomWizard;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.IWizardFactory;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.monitoring.messages.MonitoringMessages;
import com.centreon.studio.map.client.elements.monitoring.model.MonitoringTypes;
import com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs.AddAcknowledgementWizardPage;
import com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs.AddDowntimeWizardPage;
import com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs.DefaultMonitoringWizardPage;
import com.centreon.studio.map.client.elements.monitoring.model.ui.dialogs.RemoveDowntimeWizardPage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum CommandWizardFactory implements IWizardFactory
{
    INSTANCE;

    private static final Set<TypeDescriptor> SUPPORTED_TYPES;

    static {
        SUPPORTED_TYPES = new HashSet<TypeDescriptor>(10);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_ADD_ACKNOWLEDGEMENT);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_REMOVE_ACKNOWLEDGEMENT);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_ADD_DOWNTIME);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_REMOVE_DOWNTIME);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_SCHEDULE_CHECK);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_FORCE_CHECK);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_DISABLE_NOTIFICATION);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_ENABLE_NOTIFICATION);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_ENABLE_CHECK);
        SUPPORTED_TYPES.add(MonitoringTypes.COMMAND_DISABLE_CHECK);
    }

    public CustomWizardDialog createDialog(INodeRelation input, IEclipseContext context) {
        CustomWizardDialog dialog = null;
        if (input.getTarget().getType().equals((Object)MonitoringTypes.COMMAND_ADD_ACKNOWLEDGEMENT)) {
            CustomWizard wizard = new CustomWizard(MonitoringMessages.acknowledgeTitle);
            wizard.registerPage((CustomWizardPage)new AddAcknowledgementWizardPage());
            dialog = new CustomWizardDialog(wizard);
        } else if (input.getTarget().getType().equals((Object)MonitoringTypes.COMMAND_ADD_DOWNTIME)) {
            CustomWizard wizard = new CustomWizard(MonitoringMessages.downtimeTitle);
            wizard.registerPage((CustomWizardPage)new AddDowntimeWizardPage());
            dialog = new CustomWizardDialog(wizard);
        } else if (input.getTarget().getType().equals((Object)MonitoringTypes.COMMAND_REMOVE_DOWNTIME)) {
            CustomWizard wizard = new CustomWizard(MonitoringMessages.removeDowntimeTitle);
            wizard.registerPage((CustomWizardPage)new RemoveDowntimeWizardPage());
            dialog = new CustomWizardDialog(wizard);
        } else if (input.getTarget().getType().equals((Object)MonitoringTypes.COMMAND_REMOVE_ACKNOWLEDGEMENT) && input.getSource().getType() != ElementTypes.ELEMENT_SERVICE) {
            CustomWizard wizard = new CustomWizard(MonitoringMessages.removeAcknowledgmentTitle);
            wizard.registerPage((CustomWizardPage)new DefaultMonitoringWizardPage(MonitoringMessages.removeAcknowledgmentCommentMessage, MonitoringMessages.removeAcknowledgmentTitle, MonitoringMessages.removeAcknowledgmentDescription));
            dialog = new CustomWizardDialog(wizard);
        }
        if (dialog != null) {
            dialog.setInput(Arrays.asList(input));
        }
        return dialog;
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }
}

