/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.ui;

import com.centreon.studio.client.acl.ACLUtils;
import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.utils.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;

@Creatable
@Singleton
public final class PreferenceParser {
    private static final String PREFS_PAGE_EXTENSION_POINT = "com.centreon.studio.client.preference.preferencePage";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_CLASS = "class";
    private static final String ELMT_PAGE = "page";
    private static final String ATTR_TYPE = "type";
    private final BrokerEventManager eventManager;
    private final IEclipseContext context;

    private static final IPreferenceNode findNode(PreferenceManager pm, String categoryId) {
        if (StringUtils.isNullEmptyOrBlank((String)categoryId)) {
            return null;
        }
        for (IPreferenceNode node : pm.getElements(0)) {
            if (!node.getId().equals(categoryId)) continue;
            return node;
        }
        return null;
    }

    private static final String getClassURI(String definingBundleId, String spec) {
        return "bundleclass://" + definingBundleId + "/" + spec;
    }

    @Inject
    public PreferenceParser(IEclipseContext context, BrokerEventManager eventManager) {
        this.eventManager = eventManager;
        this.context = ContextUtils.getTopContext((IEclipseContext)context);
    }

    public PreferenceManager parsePreferences(IPreferenceStore store) {
        PreferenceManager manager = new PreferenceManager();
        HashMap<String, PreferencePage> idToPage = new HashMap<String, PreferencePage>();
        HashMap<String, String> idToCategory = new HashMap<String, String>();
        IExtensionRegistry registry = (IExtensionRegistry)this.context.get(IExtensionRegistry.class);
        IContributionFactory factory = (IContributionFactory)this.context.get(IContributionFactory.class);
        ACLUtils utils = (ACLUtils)ContextInjectionFactory.make(ACLUtils.class, (IEclipseContext)this.context);
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(PREFS_PAGE_EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String clazz = configurationElement.getAttribute(ATTR_CLASS);
            String actionId = configurationElement.getAttribute(ATTR_ACTION);
            String category = configurationElement.getAttribute(ATTR_CATEGORY);
            PropertyDescriptor action = PropertyDescriptor.getPropertyDescriptor((String)actionId);
            TypeDescriptor type = TypeDescriptor.getType((Integer)StringUtils.parseInt((String)configurationElement.getAttribute(ATTR_TYPE)));
            if (!configurationElement.getName().equals(ELMT_PAGE)) {
                this.eventManager.async((StudioEvent)LogEvent.error(this.getClass(), (String)"Unexpected element {}", (Object[])new Object[]{configurationElement.getName()}));
            } else if (StringUtils.isNullEmptyOrBlank((String)clazz)) {
                this.eventManager.async((StudioEvent)LogEvent.error(this.getClass(), (String)"Missing class {}", (Object[])new Object[]{configurationElement.getNamespaceIdentifier()}));
            } else if (type == null || utils.can(action, type, null, true).booleanValue()) {
                String prefPageURI = PreferenceParser.getClassURI(configurationElement.getNamespaceIdentifier(), clazz);
                Object object = factory.create(prefPageURI, this.context);
                if (!(object instanceof PreferencePage)) {
                    this.eventManager.async((StudioEvent)LogEvent.error(this.getClass(), (String)"Expected instance of PreferencePage instead of {}", (Object[])new Object[]{clazz}));
                } else {
                    PreferencePage page = (PreferencePage)object;
                    page.setPreferenceStore(store);
                    idToPage.put(clazz, page);
                    idToCategory.put(clazz, category);
                }
            }
            ++n2;
        }
        while (!idToCategory.isEmpty()) {
            Iterator iterator = idToCategory.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String id = (String)next.getKey();
                String categoryId = (String)next.getValue();
                if (StringUtils.isNullEmptyOrBlank((String)categoryId) || !idToPage.containsKey(categoryId)) {
                    manager.addToRoot((IPreferenceNode)new PreferenceNode(id, (IPreferencePage)idToPage.get(id)));
                    iterator.remove();
                    continue;
                }
                IPreferenceNode preferenceNode = PreferenceParser.findNode(manager, categoryId);
                if (preferenceNode == null) continue;
                PreferencePage pageFromId = (PreferencePage)idToPage.get(id);
                PreferenceNode nodeToAdd = new PreferenceNode(id, (IPreferencePage)pageFromId);
                preferenceNode.add((IPreferenceNode)nodeToAdd);
                iterator.remove();
            }
        }
        return manager;
    }
}

