/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.ui;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.preference.model.PreferenceRepositoryDecorator;
import com.centreon.studio.client.preference.ui.messages.PreferenceUiMessages;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;

@Creatable
@Singleton
public class StudioPreferenceStore
implements IPreferenceStore {
    private final PreferenceRepositoryDecorator repository;
    private final INode input;
    private StudioPreferenceStore parent;
    private final BrokerEventManager eventManager;

    private static INode find(INode node, Long id, TypeDescriptor type) {
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[]{type})) {
            if (!relation.getTarget().getId().equals(id)) continue;
            return relation.getTarget();
        }
        return null;
    }

    @Inject
    public StudioPreferenceStore(PreferenceRepositoryDecorator repository, BrokerEventManager eventManager) {
        this(repository, (INode)repository, eventManager);
    }

    private StudioPreferenceStore(PreferenceRepositoryDecorator repository, INode input, BrokerEventManager eventManager) {
        this.eventManager = eventManager;
        this.repository = repository;
        this.input = input;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        throw new IllegalAccessError(PreferenceUiMessages.access_error_message);
    }

    public boolean contains(String name) {
        PropertyDescriptor descriptor = PropertyDescriptor.getPropertyDescriptor((String)name);
        Object value = this.getInput().getProperty(descriptor);
        return !Objects.equals(value, descriptor.defaulValue);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        throw new IllegalAccessError(PreferenceUiMessages.access_error_message);
    }

    public boolean getBoolean(String name) {
        return this.getValue(Boolean.class, name, Boolean.FALSE);
    }

    public boolean getDefaultBoolean(String name) {
        return this.getDefaultValue(Boolean.class, name, Boolean.FALSE);
    }

    public double getDefaultDouble(String name) {
        return this.getDefaultValue(Double.class, name, Double.MIN_VALUE);
    }

    public float getDefaultFloat(String name) {
        return this.getDefaultValue(Float.class, name, Float.valueOf(Float.MIN_VALUE)).floatValue();
    }

    public int getDefaultInt(String name) {
        return this.getDefaultValue(Integer.class, name, Integer.MIN_VALUE);
    }

    public long getDefaultLong(String name) {
        return this.getDefaultValue(Long.class, name, Long.MIN_VALUE);
    }

    public String getDefaultString(String name) {
        return this.getDefaultValue(String.class, name, "");
    }

    public <T> T getDefaultValue(Class<T> clazz, String name, T errorValue) {
        PropertyDescriptor descriptor = PropertyDescriptor.getPropertyDescriptor((String)name);
        if (descriptor == null || descriptor.clazz != clazz) {
            this.eventManager.async((StudioEvent)LogEvent.error(StudioPreferenceStore.class, (String)"getDefaultValue() : descriptor {} is null or not of the type {}", (Object[])new Object[]{name, clazz}));
            return errorValue;
        }
        Object defaultValue = descriptor.defaulValue;
        for (PropertyValue pv : this.getInput().getDefaultPropertyValues()) {
            if (pv.getProperty() != descriptor) continue;
            defaultValue = pv.getValue();
            break;
        }
        return (T)defaultValue;
    }

    public double getDouble(String name) {
        return this.getValue(Double.class, name, Double.MIN_VALUE);
    }

    public float getFloat(String name) {
        return this.getValue(Float.class, name, Float.valueOf(Float.MIN_VALUE)).floatValue();
    }

    public INode getInput() {
        return this.input;
    }

    public int getInt(String name) {
        return this.getValue(Integer.class, name, Integer.MIN_VALUE);
    }

    public long getLong(String name) {
        return this.getValue(Long.class, name, Long.MIN_VALUE);
    }

    public StudioPreferenceStore getScopedStore(INode node) {
        if (this.getInput().equals((Object)node)) {
            return this;
        }
        if (node == null) {
            return this.getRoot();
        }
        INode scopedNode = StudioPreferenceStore.find(this.getInput(), node.getId(), node.getType());
        if (scopedNode == null) {
            IRepository adapted = (IRepository)this.repository.adapt(IRepository.class);
            PropertyValue scopeProperty = new PropertyValue(PropertyDescriptors.SCOPE, (Object)((INode)this.getInput().getProperty(PropertyDescriptors.SCOPE)));
            scopedNode = NodeFactories.INSTANCE.create(node.getType(), node.getId(), Arrays.asList(scopeProperty), adapted);
            this.getInput().addRelation(NodeRelationFactories.INSTANCE.create(node.getType(), node.getId(), this.getInput(), scopedNode));
        }
        StudioPreferenceStore scopedStore = new StudioPreferenceStore(this.repository, scopedNode, this.eventManager);
        scopedStore.parent = this;
        return scopedStore;
    }

    public String getString(String name) {
        return this.getValue(String.class, name, "");
    }

    public <T> T getValue(Class<T> clazz, String name, T errorValue) {
        PropertyDescriptor descriptor = PropertyDescriptor.getPropertyDescriptor((String)name);
        if (descriptor == null || descriptor.clazz != clazz) {
            this.eventManager.async((StudioEvent)LogEvent.error(StudioPreferenceStore.class, (String)"getValue() : descriptor {} is null or not of the type {}", (Object[])new Object[]{name, clazz}));
            return errorValue;
        }
        return (T)this.getInput().getProperty(descriptor);
    }

    public boolean isDefault(String name) {
        return true;
    }

    public boolean needsSaving() {
        return true;
    }

    public void putValue(String name, String value) {
        throw new IllegalAccessError(PreferenceUiMessages.access_error_message);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        throw new IllegalAccessError(PreferenceUiMessages.access_error_message);
    }

    public void setDefault(String name, boolean value) {
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
    }

    public void setDefault(String name, int value) {
    }

    public void setDefault(String name, long value) {
    }

    public void setDefault(String name, String value) {
    }

    public void setToDefault(String name) {
        PropertyDescriptor descriptor = PropertyDescriptor.getPropertyDescriptor((String)name);
        if (descriptor == null) {
            return;
        }
        this.getInput().addPropertyValue(descriptor, null);
    }

    public <T> void setValue(Class<T> clazz, String name, T value) {
        PropertyDescriptor descriptor = PropertyDescriptor.getPropertyDescriptor((String)name);
        if (descriptor == null || descriptor.clazz != clazz) {
            this.eventManager.async((StudioEvent)LogEvent.error(StudioPreferenceStore.class, (String)"setValue() : descriptor {} is null or not of the type {}", (Object[])new Object[]{name, clazz}));
            return;
        }
        this.getInput().addPropertyValue(descriptor, value);
    }

    public void setValue(String name, boolean value) {
        this.setValue(Boolean.class, name, value);
    }

    public void setValue(String name, double value) {
        this.setValue(Double.class, name, value);
    }

    public void setValue(String name, float value) {
        this.setValue(Float.class, name, Float.valueOf(value));
    }

    public void setValue(String name, int value) {
        this.setValue(Integer.class, name, value);
    }

    public void setValue(String name, long value) {
        this.setValue(Long.class, name, value);
    }

    public void setValue(String name, String value) {
        this.setValue(String.class, name, value);
    }

    private StudioPreferenceStore getRoot() {
        StudioPreferenceStore root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }
}

