/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.ui.fields;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.model.StudioFont;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.preference.ui.StudioPreferenceStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;

public class PropertyFontFieldEditor
extends FieldEditor {
    private final IForm form;
    private final PropertyDescriptor<StudioFont> pd;
    private Button changeFontButton;
    private Label valueControl;
    private FontData[] chosenFont;

    public PropertyFontFieldEditor(String preferenceName, String label, Composite parent, IForm form) {
        this.init(preferenceName, label);
        this.createControl(parent);
        this.form = form;
        this.pd = PropertyDescriptor.getPropertyDescriptor((String)preferenceName);
        Assert.isTrue((boolean)this.pd.clazz.equals(StudioFont.class));
    }

    public int getNumberOfControls() {
        return 3;
    }

    public StudioPreferenceStore getPreferenceStore() {
        return (StudioPreferenceStore)super.getPreferenceStore();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getChangeControl(parent).setEnabled(enabled);
        this.getValueControl(parent).setEnabled(enabled);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = new GridData();
        if (this.valueControl.getLayoutData() != null) {
            gd = (GridData)this.valueControl.getLayoutData();
        }
        gd.horizontalSpan = numColumns - 2;
        this.valueControl.setLayoutData((Object)gd);
    }

    protected void createControl(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 0x1000000;
        gd2.verticalAlignment = 0x1000000;
        gd2.horizontalSpan = numColumns - 2;
        this.valueControl = this.getValueControl(parent);
        this.valueControl.setLayoutData((Object)gd2);
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 0x1000008;
        gd3.verticalAlignment = 0x1000000;
        this.changeFontButton = this.getChangeControl(parent);
        this.changeFontButton.setLayoutData((Object)gd3);
    }

    protected void doLoad() {
        if (this.changeFontButton == null) {
            return;
        }
        StudioFont studioFont = this.getPreferenceStore().getValue(StudioFont.class, this.getPreferenceName(), (StudioFont)this.pd.defaulValue);
        Font swtFont = StudioRegistries.fontRegistry().getSWTFontFrom(studioFont);
        this.updateFont(swtFont.getFontData());
    }

    protected void doLoadDefault() {
        this.doLoad();
    }

    protected void doStore() {
        if (this.chosenFont != null && this.changeFontButton != null) {
            Font font = new Font((Device)this.changeFontButton.getDisplay(), this.chosenFont);
            StudioFont studioFont = StudioRegistries.fontRegistry().getStudioFontFrom(font.getFontData()[0]);
            this.getPreferenceStore().setValue(StudioFont.class, this.getPreferenceName(), studioFont);
        }
    }

    protected void fireValueChanged(String property, Object oldValue, Object newValue) {
        super.fireValueChanged(property, oldValue, newValue);
        if (this.form != null) {
            this.form.setChange((Control)this.getLabelControl(), true);
            this.form.setValidation((Control)this.getLabelControl(), true);
        }
    }

    protected Label getValueControl(Composite parent) {
        if (this.valueControl == null) {
            this.valueControl = new Label(parent, 16384);
            this.valueControl.setFont(parent.getFont());
            this.valueControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PropertyFontFieldEditor.this.valueControl = null;
                }
            });
        } else {
            this.checkParent((Control)this.valueControl, parent);
        }
        return this.valueControl;
    }

    private Button getChangeControl(Composite parent) {
        if (this.changeFontButton == null) {
            this.changeFontButton = new Button(parent, 8);
            this.changeFontButton.setText("Pick a font");
            this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FontData font;
                    FontDialog fontDialog = new FontDialog(PropertyFontFieldEditor.this.changeFontButton.getShell());
                    if (PropertyFontFieldEditor.this.chosenFont != null) {
                        fontDialog.setFontList(PropertyFontFieldEditor.this.chosenFont);
                    }
                    if ((font = fontDialog.open()) != null) {
                        FontData[] oldFont = PropertyFontFieldEditor.this.chosenFont;
                        if (oldFont == null) {
                            oldFont = JFaceResources.getDefaultFont().getFontData();
                        }
                        PropertyFontFieldEditor.this.setPresentsDefaultValue(false);
                        FontData[] newData = new FontData[]{font};
                        PropertyFontFieldEditor.this.updateFont(newData);
                        PropertyFontFieldEditor.this.fireValueChanged("field_editor_value", oldFont[0], font);
                    }
                }
            });
            this.changeFontButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PropertyFontFieldEditor.this.changeFontButton = null;
                }
            });
            this.changeFontButton.setFont(parent.getFont());
            this.setButtonLayoutData(this.changeFontButton);
        } else {
            this.checkParent((Control)this.changeFontButton, parent);
        }
        return this.changeFontButton;
    }

    private FontData[] getDefaultFontData() {
        return this.valueControl.getDisplay().getSystemFont().getFontData();
    }

    private void updateFont(FontData[] font) {
        FontData[] bestFont = JFaceResources.getFontRegistry().filterData(font, this.valueControl.getDisplay());
        if (bestFont == null) {
            bestFont = this.getDefaultFontData();
        }
        this.chosenFont = bestFont;
        if (this.valueControl != null) {
            this.valueControl.setText(StringConverter.asString((FontData)this.chosenFont[0]));
        }
    }
}

