/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.ui.pages;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.preference.ui.StudioPreferenceStore;
import com.centreon.studio.client.preference.ui.pages.APreferencePage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;

public abstract class AObjectScopedPreferencePage
extends APreferencePage
implements IPropertiesListener {
    private final Map<FieldEditor, Composite> fieldToParent = new HashMap<FieldEditor, Composite>();
    private final Map<FieldEditor, INode> fieldToScope = new HashMap<FieldEditor, INode>();
    private final Collection<IObject> registeredObjects = new HashSet<IObject>();
    private final INode scope;

    protected AObjectScopedPreferencePage(String description, INode scope) {
        super(description);
        this.scope = scope;
    }

    public final void addField(FieldEditor editor, Composite composite, INode scope) {
        super.addField(editor);
        this.fieldToParent.put(editor, composite);
        this.fieldToScope.put(editor, scope);
    }

    public void dispose() {
        super.dispose();
        super.getPreferenceStore().getInput().unregisterPropertiesListener((IPropertiesListener)this);
        for (IObject object : this.registeredObjects) {
            object.unregisterPropertiesListener((IPropertiesListener)this);
        }
    }

    @Override
    public StudioPreferenceStore getPreferenceStore() {
        StudioPreferenceStore store = super.getPreferenceStore();
        store = store.getScopedStore(this.getScope());
        return store;
    }

    public void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
    }

    protected void addField(FieldEditor editor) {
        throw new IllegalAccessError();
    }

    protected Boolean canUpdate() {
        return Boolean.TRUE;
    }

    protected INode getScope() {
        return this.scope;
    }

    @Override
    protected final void initialize() {
        super.initialize();
        if (this.saving) {
            return;
        }
        StudioPreferenceStore store = this.getPreferenceStore();
        Boolean canUpdate = this.canUpdate();
        for (Map.Entry<FieldEditor, INode> entry : this.fieldToScope.entrySet()) {
            FieldEditor field = entry.getKey();
            try {
                field.setEnabled(canUpdate.booleanValue(), this.fieldToParent.get(field));
                if (entry.getValue() == null) continue;
                StudioPreferenceStore scopedStore = store.getScopedStore(entry.getValue());
                INode scopedInput = scopedStore.getInput();
                scopedInput.unregisterPropertiesListener((IPropertiesListener)this);
                scopedInput.registerPropertiesListener((IPropertiesListener)this);
                this.registeredObjects.add((IObject)scopedInput);
                field.setPreferenceStore((IPreferenceStore)scopedStore);
                field.load();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

