/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.node;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.CollectionsUtils;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class INodeUtils {
    public static INode copy(INode toCopy, boolean sameId, boolean recursive, IRepository repository, PropertyValue ... conditions) {
        Long id = sameId ? toCopy.getId() : SequenceUtils.next();
        IRepository actualRepository = repository != null ? repository : toCopy.getRepository();
        INode copied = NodeFactories.INSTANCE.create(toCopy.getType(), id, toCopy.getPropertyValues(), actualRepository);
        if (copied == null) {
            return null;
        }
        INodeUtils.updateProperties(copied, toCopy.getPropertyValues(), true, true, new String[0]);
        if (recursive) {
            List<INodeRelation> relationsToCopy = toCopy.getRelations(new TypeDescriptor[0]);
            ArrayList<INodeRelation> copiedRelations = new ArrayList<INodeRelation>(relationsToCopy.size());
            for (INodeRelation relationToCopy : relationsToCopy) {
                boolean doCopy = true;
                PropertyValue[] propertyValueArray = conditions;
                int n = conditions.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyValue pv = propertyValueArray[n2];
                    if (relationToCopy.getTarget().getProperty(pv.getProperty()) != pv.getValue() || relationToCopy.getProperty(pv.getProperty()) != pv.getValue()) {
                        doCopy = false;
                        break;
                    }
                    ++n2;
                }
                if (!doCopy) continue;
                copiedRelations.add(INodeUtils.copy(relationToCopy, copied, sameId, recursive, repository, conditions));
            }
            copied.addRelations(copiedRelations);
        }
        return copied;
    }

    public static INodeRelation copy(INodeRelation toCopy, INode source, boolean sameId, boolean recursive, IRepository repository, PropertyValue ... conditions) {
        Long id = sameId ? toCopy.getId() : SequenceUtils.next();
        INodeRelation relation = NodeRelationFactories.INSTANCE.create(toCopy.getType(), id, source, INodeUtils.copy(toCopy.getTarget(), sameId, recursive, repository, conditions));
        INodeUtils.updateProperties(relation, toCopy.getPropertyValues(), true, true, new String[0]);
        return relation;
    }

    public static String display(INode node) {
        return INodeUtils.display(node, "");
    }

    public static INode findNode(INode parent, TypeDescriptor type, Long id, PropertyValue ... valuesToMatch) {
        if (parent == null || id == null && type == null) {
            return null;
        }
        if ((id == null || parent.getId().equals(id)) && (type == null || type == parent.getType()) && INodeUtils.match(parent, valuesToMatch)) {
            return parent;
        }
        for (INodeRelation relation : parent.getRelations(new TypeDescriptor[0])) {
            INode child = relation.getTarget();
            if (id != null && !child.getId().equals(id) || type != null && type != child.getType() || !INodeUtils.match(child, valuesToMatch)) continue;
            return child;
        }
        for (INodeRelation relation : parent.getRelations(new TypeDescriptor[0])) {
            INode found = INodeUtils.findNode(relation.getTarget(), type, id, valuesToMatch);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static void findNodes(INode parent, Collection<Long> ids, Map<Long, INode> result) {
        if (ids.isEmpty()) {
            return;
        }
        List<INodeRelation> relations = parent.getRelations(new TypeDescriptor[0]);
        for (INodeRelation relation : relations) {
            if (ids.remove(relation.getTarget().getId())) {
                result.put(relation.getTarget().getId(), relation.getTarget());
            }
            if (!ids.isEmpty()) continue;
            return;
        }
        for (INodeRelation relation : relations) {
            INodeUtils.findNodes(relation.getTarget(), ids, result);
        }
    }

    public static INodeRelation findRelation(INode parent, Long relationId, TypeDescriptor ... relationTypes) {
        if (parent == null) {
            return null;
        }
        List<INodeRelation> relations = parent.getRelations(relationTypes);
        for (INodeRelation relation : relations) {
            if (relationId != null && !relation.getId().equals(relationId)) continue;
            return relation;
        }
        List<INodeRelation> allRelations = parent.getRelations(new TypeDescriptor[0]);
        for (INodeRelation relation : allRelations) {
            INodeRelation found = INodeUtils.findRelation(relation.getTarget(), relationId, relationTypes);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static INodeRelation findRelationForTarget(INode parent, TypeDescriptor targetType, Long targetId, PropertyValue ... valuesToMatch) {
        if (parent == null || targetId == null && targetType == null && (valuesToMatch == null || valuesToMatch.length == 0)) {
            return null;
        }
        List<INodeRelation> relations = parent.getRelations(new TypeDescriptor[0]);
        for (INodeRelation relation : relations) {
            if (targetId != null && !relation.getTarget().getId().equals(targetId) || targetType != null && !relation.getTarget().getType().equals(targetType) || !INodeUtils.match(relation.getTarget(), valuesToMatch)) continue;
            return relation;
        }
        for (INodeRelation relation : relations) {
            INodeRelation found = INodeUtils.findRelationForTarget(relation.getTarget(), targetType, targetId, valuesToMatch);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static void getAllRelations(INodeRelation relation, Collection<INodeRelation> relations, Collection<TypeDescriptor> relationTypes, Collection<TypeDescriptor> nodeTypes) {
        if ((nodeTypes == null || nodeTypes.contains(relation.getTarget().getType())) && (relationTypes == null || relationTypes.contains(relation.getType()))) {
            relations.add(relation);
        }
        for (INodeRelation childRelation : relation.getTarget().getRelations(new TypeDescriptor[0])) {
            INodeUtils.getAllRelations(childRelation, relations, relationTypes, nodeTypes);
        }
    }

    public static int getTreeSize(INode root, Collection<TypeDescriptor> typesToExclude) {
        int nbElements = 1;
        for (INodeRelation relation : root.getRelations(new TypeDescriptor[0])) {
            if (typesToExclude.contains(relation.getTarget().getType())) continue;
            nbElements += INodeUtils.getTreeSize(relation.getTarget(), typesToExclude);
        }
        return nbElements;
    }

    public static void performDelta(INode toUpdate, INode updater) {
        INodeUtils.performDelta(toUpdate, updater, true, true, true, true);
    }

    public static void performDelta(INode toUpdate, INode updater, boolean isRecursive, boolean isExclusive, boolean removePropertiesNotFound, boolean useRelationIds) {
        List<INodeRelation> updaterRelations = updater.getRelations(new TypeDescriptor[0]);
        ArrayList<INodeRelation> relationsToAdd = new ArrayList<INodeRelation>(updaterRelations.size());
        for (INodeRelation newTempRelation : updaterRelations) {
            INodeRelation oldRelation = useRelationIds ? INodeUtils.findRelation(toUpdate, newTempRelation.getId(), newTempRelation.getType()) : INodeUtils.findRelationForTarget(toUpdate, newTempRelation.getTarget().getType(), newTempRelation.getTarget().getId(), new PropertyValue[0]);
            if (oldRelation != null) {
                INodeUtils.updateProperties(oldRelation, newTempRelation.getPropertyValues(), true, removePropertiesNotFound, new String[0]);
                if (!isRecursive) continue;
                INodeUtils.performDelta(oldRelation.getTarget(), newTempRelation.getTarget(), isRecursive, isExclusive, removePropertiesNotFound, useRelationIds);
                continue;
            }
            INodeRelation newRelation = NodeRelationFactories.INSTANCE.create(newTempRelation.getType(), newTempRelation.getId(), toUpdate, newTempRelation.getTarget(), newTempRelation.getPropertyValues());
            relationsToAdd.add(newRelation);
        }
        toUpdate.addRelations(relationsToAdd);
        if (isExclusive) {
            List<INodeRelation> toUpdateRelations = toUpdate.getRelations(new TypeDescriptor[0]);
            ArrayList<INodeRelation> relationsToRemove = new ArrayList<INodeRelation>(toUpdateRelations.size());
            for (INodeRelation currentRelation : toUpdateRelations) {
                INodeRelation foundRelation = useRelationIds ? INodeUtils.findRelation(updater, currentRelation.getId(), currentRelation.getType()) : INodeUtils.findRelationForTarget(updater, currentRelation.getTarget().getType(), currentRelation.getTarget().getId(), new PropertyValue[0]);
                if (foundRelation != null) continue;
                relationsToRemove.add(currentRelation);
            }
            toUpdate.removeRelations(relationsToRemove);
        }
        INodeUtils.updateProperties(toUpdate, updater.getPropertyValues(), true, removePropertiesNotFound, new String[0]);
    }

    public static void updateProperties(IObject object, Collection<PropertyValue> propertyValues, boolean updateLocals, boolean removeNotFound, String ... categoriesToExclude) {
        if (propertyValues == null) {
            return;
        }
        HashSet<String> categories = new HashSet<String>(categoriesToExclude.length);
        String[] stringArray = categoriesToExclude;
        int n = categoriesToExclude.length;
        int n2 = 0;
        while (n2 < n) {
            String categorie = stringArray[n2];
            categories.add(categorie);
            ++n2;
        }
        Collection<PropertyValue> propertyValuesToUpdate = propertyValues;
        if (!updateLocals) {
            Iterator<PropertyValue> iterator = propertyValuesToUpdate.iterator();
            while (iterator.hasNext()) {
                PropertyValue propertyValue = iterator.next();
                if (!propertyValue.getProperty().isLocal) continue;
                iterator.remove();
            }
        }
        for (PropertyValue pv : object.getPropertyValues()) {
            boolean propertyMustBeRemoved;
            boolean propertyDoesntNeedUpdate;
            boolean bl = propertyDoesntNeedUpdate = pv.getProperty().isLocal && !updateLocals || categories.contains(pv.getProperty().category);
            if (propertyDoesntNeedUpdate) continue;
            boolean found = false;
            for (PropertyValue propertyValue : propertyValuesToUpdate) {
                if (pv.getProperty() != propertyValue.getProperty()) continue;
                found = true;
                break;
            }
            boolean bl2 = propertyMustBeRemoved = !found && removeNotFound;
            if (!propertyMustBeRemoved) continue;
            propertyValuesToUpdate.add(new PropertyValue(pv.getProperty(), null));
        }
        object.addPropertyValues(propertyValuesToUpdate);
    }

    private static String display(INode node, String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append("class ");
        builder.append(node.getClass().getSimpleName());
        builder.append(" type ");
        builder.append(node.getType());
        builder.append(" id ");
        builder.append(node.getId());
        if (node.getRepository() != null) {
            builder.append(" repository ");
            builder.append(node.getRepository().getId());
        }
        builder.append(StringUtils.NEW_LINE);
        builder.append(prefix);
        builder.append("  properties : ");
        for (PropertyValue pv : node.getPropertyValues()) {
            builder.append(" ");
            builder.append(pv.getProperty());
            builder.append("=");
            builder.append(pv.getValue());
            builder.append(" ");
        }
        builder.append(StringUtils.NEW_LINE);
        builder.append(prefix);
        builder.append("  default properties : ");
        for (PropertyValue pv : node.getDefaultPropertyValues()) {
            builder.append(" ");
            builder.append(pv.getProperty());
            builder.append("=");
            builder.append(pv.getValue());
            builder.append(" ");
        }
        builder.append(StringUtils.NEW_LINE);
        Map relations = CollectionsUtils.createMultiMap((int)0, ArrayList.class);
        for (INodeRelation iNodeRelation : node.getRelations(new TypeDescriptor[0])) {
            ((Collection)relations.get(iNodeRelation.getType())).add(iNodeRelation);
        }
        for (Map.Entry entry : relations.entrySet()) {
            builder.append("relation type : ");
            builder.append(entry.getKey());
            for (INodeRelation relation : (Collection)entry.getValue()) {
                builder.append(INodeUtils.display(relation.getTarget(), String.valueOf(prefix) + "    "));
            }
        }
        return builder.toString();
    }

    private static boolean match(IObject object, PropertyValue ... valuesToMatch) {
        PropertyValue pv;
        if (valuesToMatch == null || valuesToMatch.length == 0) {
            return true;
        }
        boolean hasContent = false;
        PropertyValue[] propertyValueArray = valuesToMatch;
        int n = valuesToMatch.length;
        int n2 = 0;
        while (n2 < n) {
            pv = propertyValueArray[n2];
            if (pv != null) {
                hasContent = true;
                break;
            }
            ++n2;
        }
        if (!hasContent) {
            return true;
        }
        propertyValueArray = valuesToMatch;
        n = valuesToMatch.length;
        n2 = 0;
        while (n2 < n) {
            pv = propertyValueArray[n2];
            if (!Objects.equals(object.getProperty(pv.getProperty()), pv.getValue())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private INodeUtils() {
    }
}

