/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.properties;

import com.centreon.studio.client.model.properties.PropertySerializer;
import com.centreon.studio.client.utils.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AListPropertySerializer<E, T extends List<E>>
extends PropertySerializer<T> {
    public static final Pattern PATTERN = Pattern.compile("(.*?)(,(.*?)){4}/");
    private final Class<T> clazz;
    private final ConcreteInstance instance;

    public AListPropertySerializer(Class<T> clazz, ConcreteInstance instance) {
        super(clazz);
        this.clazz = clazz;
        this.instance = instance;
    }

    protected abstract E createElement(String var1);

    @Override
    public final T toObject(String input) {
        if (StringUtils.isNullEmptyOrBlank((String)input)) {
            return null;
        }
        try {
            String[] parts = null;
            if (this.instance == ConcreteInstance.LIST_OF_METRIC_LINE) {
                Matcher matcher = PATTERN.matcher(input);
                ArrayList<String> metricLines = new ArrayList<String>();
                while (matcher.find()) {
                    String metricLineWithSlash = matcher.group();
                    String metricLine = org.apache.commons.lang3.StringUtils.removeEnd((String)metricLineWithSlash, (String)"/");
                    metricLines.add(metricLine);
                }
                parts = metricLines.toArray(new String[metricLines.size()]);
            } else {
                parts = input.split("/");
            }
            Constructor<T> constructor = this.clazz.getConstructor(Integer.TYPE);
            List list = (List)constructor.newInstance(parts.length);
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                list.add(this.createElement(part));
                ++n2;
            }
            return (T)list;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final String toString(T list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object element : list) {
            builder.append(element);
            builder.append("/");
        }
        return builder.toString();
    }

    public static enum ConcreteInstance {
        LIST_OF_METRIC_LINE,
        DEFAULT;

    }
}

