/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.properties;

import com.centreon.studio.client.model.messages.ModelMessages;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.utils.StringUtils;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;

public final class PropertyDescriptor<T>
implements Comparable<PropertyDescriptor<?>> {
    private static final Map<String, PropertyDescriptor<?>> DESCRIPTORS = new HashMap(128);
    public final String id;
    public final String label;
    public final String category;
    public final Class<T> clazz;
    public final PropertyDescriptor<T> fallBack;
    public final boolean isLocal;
    public final T defaulValue;
    private final int hashCode;

    public static String export(boolean exportLocal, boolean json, Class<?> clazzToExport) {
        TreeSet set = new TreeSet(new Comparator<PropertyDescriptor<?>>(){

            @Override
            public int compare(PropertyDescriptor<?> o1, PropertyDescriptor<?> o2) {
                return Collator.getInstance().compare(o1.id, o2.id);
            }
        });
        for (PropertyDescriptor<?> pd : DESCRIPTORS.values()) {
            if (pd.isLocal && !exportLocal || clazzToExport != null && pd.clazz != clazzToExport) continue;
            set.add(pd);
        }
        StringBuilder builder = new StringBuilder();
        if (json) {
            builder.append("{");
        }
        for (PropertyDescriptor propertyDescriptor : set) {
            if (json) {
                builder.append(propertyDescriptor.id).append(", ");
                continue;
            }
            builder.append("id : '");
            builder.append(propertyDescriptor.id);
            builder.append("'");
            PropertyDescriptor.space(builder, 30 - propertyDescriptor.id.length());
            builder.append("type : '");
            builder.append(propertyDescriptor.clazz.getSimpleName());
            builder.append("'");
            PropertyDescriptor.space(builder, 30 - propertyDescriptor.clazz.getSimpleName().length());
            String name = propertyDescriptor.fallBack == null ? "null" : propertyDescriptor.fallBack.id;
            builder.append("fallback : '");
            builder.append(name);
            builder.append("'");
            PropertyDescriptor.space(builder, 30 - name.length());
            Class clazz = propertyDescriptor.clazz;
            PropertyFormatter pf = PropertyFormatter.getPropetyFormatter(clazz);
            builder.append("default : '");
            if (pf != null && propertyDescriptor.defaulValue != null) {
                builder.append(pf.toString(propertyDescriptor.defaulValue));
            } else {
                String defaultValue = propertyDescriptor.defaulValue == null ? "null" : propertyDescriptor.defaulValue.toString();
                builder.append(defaultValue);
            }
            builder.append("'");
            builder.append(StringUtils.NEW_LINE);
        }
        if (json) {
            builder.deleteCharAt(builder.length() - 1).deleteCharAt(builder.length() - 1).append("}");
        }
        return builder.toString();
    }

    public static final <T> PropertyDescriptor<T> getPropertyDescriptor(String id) {
        return DESCRIPTORS.get(id);
    }

    private static void space(StringBuilder builder, int number) {
        int i = 0;
        while (i < number) {
            builder.append(" ");
            ++i;
        }
    }

    public PropertyDescriptor(String id, String label, Class<T> clazz, T defaultValue, boolean isLocal) {
        this(id, label, clazz, defaultValue, null, isLocal);
    }

    public PropertyDescriptor(String id, String label, Class<T> clazz, T defaultValue, PropertyDescriptor<T> fallBack, boolean isLocal) {
        this(id, label, "Misc", clazz, defaultValue, fallBack, isLocal);
    }

    public PropertyDescriptor(String id, String label, String category, Class<T> clazz, T defaultValue, boolean isLocal) {
        this(id, label, category, clazz, defaultValue, null, isLocal);
    }

    public PropertyDescriptor(String id, String label, String category, Class<T> clazz, T defaulValue, PropertyDescriptor<T> fallBack, boolean isLocal) {
        Assert.isTrue((!StringUtils.isOneNullEmptyOrBlank((String[])new String[]{id, label}) && clazz != null ? 1 : 0) != 0, (String)"id, label nor clazz must not be null");
        Assert.isTrue((DESCRIPTORS.put(id, this) == null ? 1 : 0) != 0, (String)(String.valueOf(id) + ModelMessages.alreadyExists));
        this.id = id;
        this.label = label;
        this.category = category;
        this.clazz = clazz;
        this.isLocal = isLocal;
        this.fallBack = fallBack;
        this.defaulValue = defaulValue;
        this.hashCode = id.hashCode();
    }

    @Override
    public int compareTo(PropertyDescriptor<?> o) {
        if (o == null) {
            return -1;
        }
        return this.label.compareTo(o.label);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.label;
    }
}

