/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.properties;

import com.centreon.studio.client.model.properties.PropertyDescriptor;
import org.eclipse.core.runtime.Assert;

public final class PropertyValue {
    private final PropertyDescriptor<?> property;
    private final Object value;
    private final Object oldValue;

    public static PropertyValue unchecked(PropertyDescriptor<?> descriptor, Object value) {
        return PropertyValue.unchecked(descriptor, null, value);
    }

    public static PropertyValue unchecked(PropertyDescriptor<?> descriptor, Object oldValue, Object value) {
        return new PropertyValue(descriptor, oldValue, value);
    }

    public <T> PropertyValue(PropertyDescriptor<T> property, T value) {
        this(property, null, value);
    }

    private <T> PropertyValue(PropertyDescriptor<T> property, T oldValue, T newValue) {
        Assert.isNotNull(property, (String)"property cannot be null");
        this.property = property;
        this.value = newValue;
        this.oldValue = oldValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyValue other = (PropertyValue)obj;
        if (!this.property.equals(other.property)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public PropertyDescriptor<?> getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.property.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        return this.property + " changed from " + this.oldValue + " to " + this.value;
    }
}

