/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.relation;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.INodeRelationFactory;
import com.centreon.studio.client.model.relation.TargetDelegateNodeRelation;
import com.centreon.studio.client.utils.SequenceUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public enum NodeRelationFactories implements INodeRelationFactory
{
    INSTANCE;

    private final Map<TypeDescriptor, INodeRelationFactory> factories = new HashMap<TypeDescriptor, INodeRelationFactory>(8);

    public INodeRelation create(INode source, INode target) {
        return this.create(null, SequenceUtils.next(), source, target, null);
    }

    public INodeRelation create(TypeDescriptor type, Long id, INode source, INode target) {
        return this.create(type, id, source, target, null);
    }

    @Override
    public INodeRelation create(TypeDescriptor type, Long id, INode source, INode target, Collection<PropertyValue> properties) {
        INodeRelationFactory factory = this.factories.get(type);
        if (factory == null) {
            return new TargetDelegateNodeRelation(source, target);
        }
        return factory.create(type, id, source, target, properties);
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    public void register(INodeRelationFactory factory) {
        Assert.isTrue((factory != null && factory.getSupportedTypes() != null ? 1 : 0) != 0, (String)"factory and supported types must not be null");
        for (TypeDescriptor supportedType : factory.getSupportedTypes()) {
            this.factories.put(supportedType, factory);
        }
    }
}

