/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo;

import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.ListOfLatLng;
import com.centreon.studio.client.model.properties.AListPropertySerializer;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.properties.PropertySerializer;
import com.centreon.studio.client.model.ui.dialogs.IWizardFactory;
import com.centreon.studio.client.model.ui.dialogs.WizardFactories;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.geo.model.GeoWizardFactory;
import com.centreon.studio.map.client.elements.geo.tiles.StyleDescription;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class Activator
implements BundleActivator {
    private static BundleContext context;

    static {
        new PropertySerializer<LatLng>(LatLng.class){

            public LatLng toObject(String input) {
                return LatLng.create((String)input);
            }
        };
        new PropertyFormatter<LatLng>(LatLng.class){

            public String toString(LatLng input) {
                if (input == null) {
                    return "";
                }
                return "(" + StringUtils.format((Double)input.x) + ";" + StringUtils.format((Double)input.y) + ")";
            }
        };
        new PropertySerializer<StyleDescription>(StyleDescription.class){

            public StyleDescription toObject(String input) {
                String[] data = input.split("/");
                return new StyleDescription(data[0], data[1], data[2]);
            }

            public String toString(StyleDescription input) {
                return String.valueOf(input.id) + "/" + input.name + "/" + input.owner;
            }
        };
        new PropertyFormatter<StyleDescription>(StyleDescription.class){};
        new AListPropertySerializer<LatLng, ListOfLatLng>(ListOfLatLng.class, AListPropertySerializer.ConcreteInstance.DEFAULT){

            protected LatLng createElement(String part) {
                return LatLng.create((String)part);
            }
        };
        new PropertyFormatter<ListOfLatLng>(ListOfLatLng.class){

            public String toString(ListOfLatLng input) {
                if (input == null || input.isEmpty()) {
                    return "";
                }
                StringBuilder builder = new StringBuilder();
                for (LatLng latlong : input) {
                    if (builder.length() > 0) {
                        builder.append(" ");
                    }
                    builder.append(PropertyFormatter.getPropetyFormatter(LatLng.class).toString((Object)latlong));
                }
                return builder.toString();
            }
        };
    }

    public static synchronized BundleContext getContext() {
        return context;
    }

    private static synchronized void setContext(BundleContext bundleContext) {
        context = bundleContext;
    }

    public void start(BundleContext bundleContext) {
        Activator.setContext(bundleContext);
        WizardFactories.INSTANCE.register((IWizardFactory)GeoWizardFactory.INSTANCE);
    }

    public void stop(BundleContext bundleContext) {
        Activator.setContext(null);
    }
}

