/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.gef.EditPartFactories;
import com.centreon.studio.client.gef.IEditPartFactory;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.ILayoutUtils;
import com.centreon.studio.client.model.ui.LayoutUtils;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actions.common.StudioActionGroup;
import com.centreon.studio.client.model.ui.actionsets.ActionSetContributor;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.geo.gef.GeoEditPartFactory;
import com.centreon.studio.map.client.elements.geo.messages.GeoMessages;
import com.centreon.studio.map.client.elements.geo.model.GeoLayoutUtils;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.geo.model.GeoRepositoryStrategy;
import com.centreon.studio.map.client.elements.geo.model.ui.actions.ResetPositionAction;
import com.centreon.studio.map.client.elements.geo.model.ui.actions.SavePositionAction;
import com.centreon.studio.map.client.elements.model.repository.decorators.ElementRepositoryDecorator;
import com.centreon.studio.map.client.elements.model.ui.actionsets.ElementToolbarActionSetDescriptor;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;

@Creatable
@Singleton
public final class GeoAddon
implements ActionSetContributor {
    private static String MAPBOX_CONFIGURATION_URL = "https://documentation.centreon.com/docs/centreon-map-4/en/latest/guide/exploitation/mapbox.html";

    @Inject
    public static void setUser(@Optional ACLUser user) {
        boolean enableGeo = user != null && !StringUtils.isNullEmptyOrBlank((String)((String)user.getProperty(GeoPropertyDescriptors.MAPBOX_TOKEN)));
        EditPartFactories.INSTANCE.register((IEditPartFactory)new GeoEditPartFactory(enableGeo));
    }

    @Inject
    public GeoAddon(ElementRepositoryDecorator repository, GeoRepositoryStrategy geoStrategy) {
        repository.getStrategies().add(0, geoStrategy);
        LayoutUtils.INSTANCE.register((ILayoutUtils)new GeoLayoutUtils());
        ActionSetDescriptor.contribute(ElementToolbarActionSetDescriptor.class, (ActionSetContributor)this);
    }

    public void contribute(List<StudioAction> actions, IEclipseContext context) {
        IRepository repository = (IRepository)ContextInjectionFactory.make(ElementRepositoryDecorator.class, (IEclipseContext)context);
        StudioActionGroup group = new StudioActionGroup(GeoMessages.savePosition);
        group.addAction((StudioAction)new SavePositionAction(repository));
        group.addAction((StudioAction)new ResetPositionAction(repository));
        actions.add(actions.size() - 2, (StudioAction)group);
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager) {
        eventManager.async((StudioEvent)ExceptionEvent.registerException((String)GeoMessages.mapboxTileError, (String)MAPBOX_CONFIGURATION_URL));
        eventManager.async((StudioEvent)LogEvent.trace(this.getClass(), (String)"Geo addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        eventManager.async((StudioEvent)LogEvent.trace(this.getClass(), (String)"Geo addon destroyed", (Object[])new Object[0]));
    }
}

