/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.gef;

import com.centreon.studio.client.gef.editparts.INodeEditPart;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.map.client.elements.ElementEditPartFactory;
import com.centreon.studio.map.client.elements.geo.gef.GeoDefaultInputGraphicalEditPart;
import com.centreon.studio.map.client.elements.geo.gef.GeoInputGraphicalEditPart;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.gef.EditPart;

public class GeoEditPartFactory
extends ElementEditPartFactory {
    private static final Collection<TypeDescriptor> SUPPORTED_TYPES = new ArrayList<TypeDescriptor>(10);
    private final boolean enableGeo;

    static {
        SUPPORTED_TYPES.add(ElementTypes.ELEMENT_CONTAINER);
        SUPPORTED_TYPES.add(ElementTypes.ELEMENT_HOST_GROUP);
    }

    public GeoEditPartFactory(boolean enableGeo) {
        this.enableGeo = enableGeo;
    }

    public INodeEditPart createEditPart(EditPart context, Object model) {
        INodeRelation relation = (INodeRelation)model;
        if (context == null) {
            if (this.enableGeo && ((Boolean)relation.getTarget().getProperty(GeoPropertyDescriptors.IS_GEO)).booleanValue()) {
                return new GeoInputGraphicalEditPart(relation, ElementTypes.RELATION_HIERARCHY, ElementTypes.RELATION_HIERARCHY_GRAPHIC);
            }
            return new GeoDefaultInputGraphicalEditPart(relation, ElementTypes.RELATION_HIERARCHY, ElementTypes.RELATION_HIERARCHY_GRAPHIC);
        }
        return super.createEditPart(context, model);
    }

    public Collection<TypeDescriptor> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }
}

