/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.gef;

import com.centreon.studio.client.gef.commands.YesCommand;
import com.centreon.studio.client.gef.editparts.ANodeRelationConnectionEditPart;
import com.centreon.studio.client.gef.editparts.ANodeRelationGraphicalEditPart;
import com.centreon.studio.client.model.ListOfPos;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.map.client.elements.geo.gef.GeoInputGraphicalEditPart;
import com.centreon.studio.map.client.elements.geo.model.ui.actions.GeoPanningAction;
import java.util.ArrayList;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.graphics.Cursor;

public class GeoPanningTracker
extends DragEditPartsTracker {
    private final GeoInputGraphicalEditPart source;
    private Point initialLocation;
    private Point initialSourceLocation;

    public GeoPanningTracker(GeoInputGraphicalEditPart source) {
        super((EditPart)source);
        this.source = source;
    }

    protected Command getCommand() {
        if (this.isInState(4)) {
            return YesCommand.getInstance();
        }
        return super.getCommand();
    }

    protected String getDebugName() {
        return "PanningTracker";
    }

    protected Cursor getDefaultCursor() {
        if (this.isInState(4)) {
            return Cursors.SIZEALL;
        }
        return super.getDefaultCursor();
    }

    protected boolean handleButtonUp(int button) {
        if (button == 1 && this.isInState(4)) {
            IRepository input = this.source.getModel().getTarget().getRepository();
            new GeoPanningAction(input, this.getPanningDelta()).run();
            this.setState(1);
        }
        return super.handleButtonUp(button);
    }

    protected boolean handleDrag() {
        if (this.getCanvas() != null && this.isInState(4)) {
            Pos delta = this.getPanningDelta();
            Point newLocation = this.initialSourceLocation.getCopy().translate(delta.x.intValue(), delta.y.intValue());
            this.source.getFigure().setLocation(newLocation);
            ArrayList connexions = new ArrayList();
            for (Object child : this.source.getChildren()) {
                ANodeRelationGraphicalEditPart childPart = (ANodeRelationGraphicalEditPart)child;
                Pos newPos = ((Pos)childPart.getModel().getProperty(PropertyDescriptors.CURRENT_POSITION)).plus(delta);
                childPart.getFigure().setLocation(new Point(newPos.x.intValue(), newPos.y.intValue()));
                connexions.addAll(childPart.getSourceConnections());
            }
            for (Object connexion : connexions) {
                ANodeRelationConnectionEditPart conxPart = (ANodeRelationConnectionEditPart)connexion;
                ListOfPos bendpoints = (ListOfPos)conxPart.getModel().getTarget().getProperty(PropertyDescriptors.BENDPOINTS);
                if (bendpoints.isEmpty()) continue;
                ListOfPos newBendpoints = new ListOfPos(bendpoints.size());
                for (Pos bendpoint : bendpoints) {
                    newBendpoints.add((Object)bendpoint.plus(delta));
                }
                ANodeRelationConnectionEditPart.setBendpoints((Connection)conxPart.getFigure(), (ListOfPos)newBendpoints);
            }
            return true;
        }
        return false;
    }

    protected boolean handleDragStarted() {
        this.initialLocation = this.getLocation();
        this.initialSourceLocation = this.source.getFigure().getBounds().getLocation();
        this.setState(4);
        this.refreshCursor();
        return true;
    }

    private FigureCanvas getCanvas() {
        if (this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            return (FigureCanvas)this.getCurrentViewer().getControl();
        }
        return null;
    }

    private Pos getPanningDelta() {
        Point location = this.getLocation();
        int x = location.x - this.initialLocation.x;
        int y = location.y - this.initialLocation.y;
        return Pos.create((double)x, (double)y);
    }
}

