/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.model;

import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.CheckField;
import com.centreon.studio.client.commons.jface.validation.field.impl.ComboField;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.LatLngTextField;
import com.centreon.studio.client.model.StyleTypes;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.DefaultPropertiesWizardPage;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.geo.messages.GeoMessages;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.geo.providers.MapBoxProvider;
import com.centreon.studio.map.client.elements.geo.tiles.StyleDescription;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.model.ui.wizards.ElementPropertiesWizardPage;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class GeoElementPropertiesWizardPage
extends ElementPropertiesWizardPage {
    private final MapBoxProvider provider;
    private final boolean enableGeo;
    private ComboField zoomField;
    private ComboField styleField;
    private CheckField isGeoField;
    private LatLngTextField latLongField;

    public GeoElementPropertiesWizardPage(MapBoxProvider provider, boolean enableGeo) {
        super(GeoElementPropertiesWizardPage.class.getSimpleName());
        this.enableGeo = enableGeo;
        this.provider = provider;
    }

    public Composite customCreateControl(Composite parent) {
        Control c;
        Combo combo;
        Composite composite = super.customCreateControl(parent);
        StyleDescription style = (StyleDescription)this.getInput().getTarget().getProperty(GeoPropertyDescriptors.MAPBOX_STYLE);
        final Boolean isParentGeo = (Boolean)this.getInput().getSource().getProperty(GeoPropertyDescriptors.IS_GEO);
        LatLng initialLatLng = (LatLng)this.getInput().getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
        Boolean isGeo = (Boolean)this.getInput().getTarget().getProperty(GeoPropertyDescriptors.IS_GEO);
        ((Text)this.xField.getControl()).setEnabled(isParentGeo == false);
        ((Text)this.yField.getControl()).setEnabled(isParentGeo == false);
        if (this.canBeGeoParent()) {
            this.isGeoField = new CheckField(SWTUtils.createButtonCheck((Composite)composite), GeoPropertyDescriptors.IS_GEO.label, isGeo, this.getForm(), (ControlValidators.IControlValidator)new ControlValidators.AControlValidator<Button>(){

                public String getMessage() {
                    return GeoMessages.mapboxConfiguration;
                }

                public boolean validate(Button control) {
                    if (GeoElementPropertiesWizardPage.this.isGeoField == null || !GeoElementPropertiesWizardPage.this.isGeoField.getValue().booleanValue()) {
                        return true;
                    }
                    return GeoElementPropertiesWizardPage.this.enableGeo && !StringUtils.isNullEmptyOrBlank((String)GeoElementPropertiesWizardPage.this.styleField.getValue());
                }
            });
            DefaultPropertiesWizardPage.moveControlAndLabel((Control)this.isGeoField.getControl(), (Control)this.yField.getControl(), (boolean)true);
        }
        if (this.canBeGeoParent() || isParentGeo.booleanValue()) {
            this.latLongField = new LatLngTextField(composite, ElementPropertyDescriptors.LATLNG.label, initialLatLng, null, this.getForm());
            ((Text)this.latLongField.getControl()).setEnabled(isParentGeo != false || isGeo != false);
            Control c2 = this.isGeoField != null ? this.isGeoField.getControl() : this.yField.getControl();
            DefaultPropertiesWizardPage.moveControlAndLabel((Control)this.latLongField.getControl(), (Control)c2, (boolean)true);
        }
        if (this.canBeGeoParent() || this.hasZoom()) {
            Object[] values = new Double[MapBoxProvider.getZoomLevels().length];
            int i = 0;
            while (i < MapBoxProvider.getZoomLevels().length) {
                values[i] = MapBoxProvider.getZoomLevels()[i];
                ++i;
            }
            combo = CustomWizardPage.createDescriptorCombo((Composite)composite, (IObject)this.getInput().getTarget(), (PropertyDescriptor)PropertyDescriptors.CURRENT_ZOOM, (Object[])values);
            this.zoomField = new ComboField(combo, null, this.getForm(), null);
            ((Combo)this.zoomField.getControl()).setEnabled((this.canBeGeoParent() ? isGeo : isParentGeo).booleanValue());
            if (StringUtils.isNullEmptyOrBlank((String)this.zoomField.getValue())) {
                this.zoomField.setValue((Object)((Double)PropertyDescriptors.CURRENT_ZOOM.defaulValue).toString());
            }
            c = this.latLongField != null ? this.latLongField.getControl() : this.yField.getControl();
            DefaultPropertiesWizardPage.moveControlAndLabel((Control)this.zoomField.getControl(), (Control)c, (boolean)true);
        }
        if (this.canBeGeoParent()) {
            Object[] styles = this.provider.getStyles().toArray(new StyleDescription[this.provider.getStyles().size()]);
            combo = CustomWizardPage.createDescriptorCombo((Composite)composite, (IObject)this.getInput().getTarget(), GeoPropertyDescriptors.MAPBOX_STYLE, (Object[])styles);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GeoElementPropertiesWizardPage.this.isGeoField.handleEvent(null);
                }
            });
            this.styleField = new ComboField(combo, null, this.getForm(), null);
            ((Combo)this.styleField.getControl()).setEnabled(isGeo.booleanValue());
            if (style != null) {
                this.styleField.setValue((Object)style.name);
            }
            DefaultPropertiesWizardPage.moveControlAndLabel((Control)this.styleField.getControl(), (Control)this.zoomField.getControl(), (boolean)true);
            c = this.canBeGeoParent() || this.hasZoom() ? this.zoomField.getControl() : (this.canBeGeoParent() || isParentGeo != false ? this.latLongField.getControl() : this.yField.getControl());
            DefaultPropertiesWizardPage.moveControlAndLabel((Control)this.styleField.getControl(), (Control)c, (boolean)true);
            ((Button)this.isGeoField.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((Text)GeoElementPropertiesWizardPage.this.latLongField.getControl()).setEnabled(isParentGeo != false || ((Button)GeoElementPropertiesWizardPage.this.isGeoField.getControl()).getSelection());
                    ((Combo)GeoElementPropertiesWizardPage.this.zoomField.getControl()).setEnabled(isParentGeo != false || ((Button)GeoElementPropertiesWizardPage.this.isGeoField.getControl()).getSelection());
                    ((Combo)GeoElementPropertiesWizardPage.this.styleField.getControl()).setEnabled(isParentGeo != false || ((Button)GeoElementPropertiesWizardPage.this.isGeoField.getControl()).getSelection());
                    ((Text)GeoElementPropertiesWizardPage.this.xField.getControl()).setEnabled(((Text)GeoElementPropertiesWizardPage.this.latLongField.getControl()).isEnabled());
                    ((Text)GeoElementPropertiesWizardPage.this.yField.getControl()).setEnabled(((Text)GeoElementPropertiesWizardPage.this.latLongField.getControl()).isEnabled());
                    if (StringUtils.isNullEmptyOrBlank((String)GeoElementPropertiesWizardPage.this.styleField.getValue()) && ((Combo)GeoElementPropertiesWizardPage.this.styleField.getControl()).getItemCount() > 0) {
                        GeoElementPropertiesWizardPage.this.styleField.setValue((Object)((Combo)GeoElementPropertiesWizardPage.this.styleField.getControl()).getItem(0));
                    }
                }
            });
        }
        return composite;
    }

    public Point getPageSize() {
        Point size = super.getPageSize();
        size.y += 100;
        return size;
    }

    protected boolean hasColor() {
        return super.hasColor() && (!this.hasResource() || (Boolean)this.getInput().getSource().getProperty(GeoPropertyDescriptors.IS_GEO) == false || this.getInput().getTarget().getProperty(PropertyDescriptors.STYLE) != StyleTypes.DEFAULT_STYLE);
    }

    protected boolean performFinish() {
        if (super.performFinish()) {
            ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(2);
            if (this.isGeoField != null && ((Button)this.isGeoField.getControl()).isEnabled()) {
                values.add(new PropertyValue(GeoPropertyDescriptors.IS_GEO, (Object)this.isGeoField.getValue()));
            }
            this.getInput().getTarget().addPropertyValues(values);
            if (this.latLongField != null) {
                this.getInput().addPropertyValues(Arrays.asList(new PropertyValue(GeoPropertyDescriptors.CURRENT_LATLNG, null), new PropertyValue(ElementPropertyDescriptors.LATLNG, (Object)this.latLongField.getValue())));
            }
            return true;
        }
        return false;
    }

    private boolean canBeGeoParent() {
        return this.getInput().getTarget().getType() == ElementTypes.ELEMENT_CONTAINER || this.getInput().getTarget().getType() == ElementTypes.ELEMENT_HOST_GROUP;
    }

    private boolean hasZoom() {
        return (Boolean)this.getInput().getSource().getProperty(GeoPropertyDescriptors.IS_GEO) != false && (this.getInput().getTarget().getType() == ElementTypes.ELEMENT_SHAPE || this.getInput().getTarget().getType() == ElementTypes.ELEMENT_MEDIA_IMAGE);
    }
}

