/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.geo.model;

import com.centreon.studio.client.model.LatLng;
import com.centreon.studio.client.model.ListOfLatLng;
import com.centreon.studio.client.model.ListOfPos;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.StudioTypes;
import com.centreon.studio.client.model.decoration.node.NodeDecorator;
import com.centreon.studio.client.model.decoration.object.ObjectDecorator;
import com.centreon.studio.client.model.decoration.relation.RelationDecorator;
import com.centreon.studio.client.model.decoration.repository.ARepositoryStrategy;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.map.client.elements.geo.model.GeoPropertyDescriptors;
import com.centreon.studio.map.client.elements.geo.providers.MapBoxProvider;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.resources.model.ResourcePropertyDescriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.gef.GraphicalViewer;

@Creatable
@Singleton
public class GeoRepositoryStrategy
extends ARepositoryStrategy {
    private static final Collection<TypeDescriptor> TYPES_TO_SCALE = Arrays.asList(ElementTypes.ELEMENT_SHAPE, ElementTypes.ELEMENT_MEDIA_IMAGE);

    private static void addPropertyValues(INode node, Collection<PropertyValue> propertyValues) {
        Boolean isGeo = GeoRepositoryStrategy.getProperty(GeoPropertyDescriptors.IS_GEO, false, propertyValues);
        if (Boolean.FALSE.equals(isGeo)) {
            propertyValues.add(new PropertyValue(PropertyDescriptors.ZOOM, null));
            propertyValues.add(new PropertyValue(PropertyDescriptors.CURRENT_ZOOM, null));
        } else if (Boolean.TRUE.equals(isGeo)) {
            LatLng latLng = (LatLng)node.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
            Double zoom = (Double)node.getProperty(PropertyDescriptors.CURRENT_ZOOM);
            GeoRepositoryStrategy.updateChildren(node, latLng, zoom);
        }
        ListOfPos bendpoints = (ListOfPos)GeoRepositoryStrategy.getProperty(PropertyDescriptors.BENDPOINTS, false, propertyValues);
        if (bendpoints != null && !bendpoints.isEmpty()) {
            INodeRelation parentRelation = INodeUtils.findRelationForTarget((INode)node.getRepository(), (TypeDescriptor)node.getType(), (Long)node.getId(), (PropertyValue[])new PropertyValue[0]);
            ListOfLatLng bendlatlongs = new ListOfLatLng(bendpoints.size());
            for (Pos bendpoint : bendpoints) {
                bendlatlongs.add((Object)GeoRepositoryStrategy.computeLatLng(parentRelation.getSource(), bendpoint));
            }
            propertyValues.add(new PropertyValue(GeoPropertyDescriptors.BENDLATLNGS, (Object)bendlatlongs));
        }
    }

    private static void addPropertyValues(INodeRelation relation, Collection<PropertyValue> propertyValues) {
        INode source = relation.getSource();
        if (((Boolean)source.getProperty(GeoPropertyDescriptors.IS_GEO)).booleanValue()) {
            LatLng latlng = (LatLng)GeoRepositoryStrategy.getProperty(ElementPropertyDescriptors.LATLNG, false, propertyValues);
            Double parentZoom = (Double)source.getProperty(PropertyDescriptors.CURRENT_ZOOM);
            if (latlng != null) {
                LatLng parentLatLng = (LatLng)source.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
                Pos pos = MapBoxProvider.latLngToPoint(latlng, parentZoom.intValue(), parentLatLng);
                propertyValues.add(new PropertyValue(PropertyDescriptors.CURRENT_POSITION, (Object)pos));
            } else {
                Pos pos = (Pos)GeoRepositoryStrategy.getProperty(PropertyDescriptors.CURRENT_POSITION, true, propertyValues);
                if (pos == null) {
                    pos = (Pos)GeoRepositoryStrategy.getProperty(PropertyDescriptors.POSITION, true, propertyValues);
                }
                if (pos != null) {
                    latlng = GeoRepositoryStrategy.computeLatLng(source, pos);
                    propertyValues.add(new PropertyValue(ElementPropertyDescriptors.LATLNG, (Object)latlng));
                    propertyValues.add(new PropertyValue(PropertyDescriptors.CURRENT_POSITION, (Object)pos));
                    INode target = relation.getTarget();
                    ListOfPos points = (ListOfPos)target.getProperty(PropertyDescriptors.POINTS);
                    if (!points.isEmpty()) {
                        Pos origin = pos.minus(((Pos)relation.getProperty(PropertyDescriptors.CURRENT_DIMENSION)).div(2.0));
                        ListOfLatLng latlongs = new ListOfLatLng(points.size());
                        for (Pos point : points) {
                            Pos absolutePoint = point.plus(origin);
                            latlongs.add((Object)GeoRepositoryStrategy.computeLatLng(source, absolutePoint));
                        }
                        target.addPropertyValue(GeoPropertyDescriptors.LATLNGS, (Object)latlongs);
                    }
                }
            }
            Pos dim = (Pos)GeoRepositoryStrategy.getProperty(PropertyDescriptors.DIMENSION, false, propertyValues);
            if (dim != null && TYPES_TO_SCALE.contains(relation.getType())) {
                Pos currentDim = (Pos)relation.getProperty(PropertyDescriptors.CURRENT_DIMENSION);
                Pos actualDim = dim;
                if (currentDim != Pos.NULL) {
                    Pos deltaDim = dim.minus(currentDim);
                    Pos deltaRatio = deltaDim.div(currentDim).plus(1.0, 1.0);
                    actualDim = ((Pos)relation.getProperty(PropertyDescriptors.DIMENSION)).mul(deltaRatio);
                }
                propertyValues.add(new PropertyValue(PropertyDescriptors.DIMENSION, (Object)actualDim));
                propertyValues.add(new PropertyValue(PropertyDescriptors.CURRENT_DIMENSION, (Object)dim));
                propertyValues.add(new PropertyValue(PropertyDescriptors.ZOOM, (Object)parentZoom));
            }
        }
    }

    private static LatLng computeLatLng(INode parent, Pos pos) {
        Double zoom = (Double)parent.getProperty(PropertyDescriptors.CURRENT_ZOOM);
        LatLng center = (LatLng)parent.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
        return MapBoxProvider.pointToLatLng(pos, zoom.intValue(), center);
    }

    private static LatLng getLatLngFromCentreonWeb(INodeRelation relation) {
        LatLng latLng = (LatLng)relation.getProperty(ElementPropertyDescriptors.LATLNG);
        if (((LatLng)ElementPropertyDescriptors.LATLNG.defaulValue).equals((Object)latLng)) {
            latLng = (LatLng)relation.getTarget().getProperty(ResourcePropertyDescriptors.COORDS_GEO);
        }
        if (((LatLng)ElementPropertyDescriptors.LATLNG.defaulValue).equals((Object)latLng)) {
            latLng = LatLng.create((String)((String)relation.getTarget().getProperty(ResourcePropertyDescriptors.COMMENT)));
        }
        return latLng;
    }

    private static final <T> T getProperty(PropertyDescriptor<T> property, boolean remove, Collection<PropertyValue> propertyValues) {
        Object value = null;
        Iterator<PropertyValue> it = propertyValues.iterator();
        while (it.hasNext()) {
            PropertyValue pv = it.next();
            if (pv.getProperty() != property) continue;
            value = pv.getValue();
            if (!remove) break;
            it.remove();
            break;
        }
        return (T)value;
    }

    private static void propertiesChanged(INode node, Collection<PropertyValue> propertyValues) {
        if (!((Boolean)node.getProperty(GeoPropertyDescriptors.IS_GEO)).booleanValue()) {
            return;
        }
        LatLng parentLatLng = GeoRepositoryStrategy.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG, false, propertyValues);
        Double parentZoom = (Double)GeoRepositoryStrategy.getProperty(PropertyDescriptors.CURRENT_ZOOM, false, propertyValues);
        if (parentLatLng != null || parentZoom != null) {
            if (parentLatLng == null) {
                parentLatLng = (LatLng)node.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
            }
            if (parentZoom == null) {
                parentZoom = (Double)node.getProperty(PropertyDescriptors.CURRENT_ZOOM);
            }
            GeoRepositoryStrategy.updateChildren(node, parentLatLng, parentZoom);
        }
    }

    private static void propertiesChanged(INodeRelation relation, Collection<PropertyValue> propertyValues) {
        Pos dim;
        if (((Boolean)relation.getTarget().getProperty(GeoPropertyDescriptors.IS_GEO)).booleanValue()) {
            LatLng latlng = (LatLng)GeoRepositoryStrategy.getProperty(ElementPropertyDescriptors.LATLNG, false, propertyValues);
            LatLng currentLatlng = GeoRepositoryStrategy.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG, false, propertyValues);
            ArrayList<PropertyValue> targetProperties = new ArrayList<PropertyValue>(2);
            if (latlng != null) {
                targetProperties.add(new PropertyValue(ElementPropertyDescriptors.LATLNG, (Object)latlng));
            }
            if (currentLatlng != null) {
                targetProperties.add(new PropertyValue(GeoPropertyDescriptors.CURRENT_LATLNG, (Object)currentLatlng));
            }
            ((INodeRelation)relation.adapt(INodeRelation.class)).getTarget().addPropertyValues(targetProperties);
        }
        if (((Boolean)relation.getSource().getProperty(GeoPropertyDescriptors.IS_GEO)).booleanValue() && (dim = (Pos)GeoRepositoryStrategy.getProperty(PropertyDescriptors.DIMENSION, false, propertyValues)) != null) {
            Double zoom = (Double)relation.getSource().getProperty(PropertyDescriptors.CURRENT_ZOOM);
            relation.getTarget().addPropertyValue(PropertyDescriptors.ZOOM, (Object)zoom);
        }
    }

    private static void updateChildren(INode node, LatLng newLatLng, Double newZoom) {
        List relations = node.getRelations(new TypeDescriptor[]{ElementTypes.RELATION_HIERARCHY, ElementTypes.RELATION_HIERARCHY_GRAPHIC, StudioTypes.RELATION_LINK});
        for (INodeRelation relation : relations) {
            ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(2);
            LatLng childLatLng = (LatLng)relation.getProperty(ElementPropertyDescriptors.LATLNG);
            Pos pos = MapBoxProvider.latLngToPoint(childLatLng, newZoom.intValue(), newLatLng);
            properties.add(new PropertyValue(PropertyDescriptors.CURRENT_POSITION, (Object)pos));
            ListOfLatLng bendlatlngs = (ListOfLatLng)relation.getTarget().getProperty(GeoPropertyDescriptors.BENDLATLNGS);
            if (!bendlatlngs.isEmpty()) {
                ListOfPos points = new ListOfPos(bendlatlngs.size());
                for (LatLng latlng : bendlatlngs) {
                    points.add((Object)MapBoxProvider.latLngToPoint(latlng, newZoom.intValue(), newLatLng));
                }
                relation.getTarget().addPropertyValue(PropertyDescriptors.BENDPOINTS, (Object)points);
            }
            if (TYPES_TO_SCALE.contains(relation.getTarget().getType())) {
                Double childZoom = (Double)relation.getTarget().getProperty(PropertyDescriptors.CURRENT_ZOOM);
                int deltaZoom = childZoom.intValue() - newZoom.intValue();
                Pos dimension = (Pos)relation.getProperty(PropertyDescriptors.DIMENSION);
                Pos scaledDimension = dimension.div(Math.pow(2.0, deltaZoom));
                properties.add(new PropertyValue(PropertyDescriptors.CURRENT_DIMENSION, (Object)scaledDimension));
            }
            ((INodeRelation)relation.adapt(INodeRelation.class)).addPropertyValues(properties);
        }
    }

    public void addPropertyValues(ObjectDecorator decorated, Collection<PropertyValue> propertyValues) {
        if (decorated instanceof INodeRelation) {
            GeoRepositoryStrategy.addPropertyValues((INodeRelation)decorated, propertyValues);
        } else if (decorated instanceof INode) {
            GeoRepositoryStrategy.addPropertyValues((INode)decorated, propertyValues);
        }
    }

    public void addRelations(NodeDecorator node, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            if (!((Boolean)relation.getSource().getProperty(GeoPropertyDescriptors.IS_GEO)).booleanValue()) continue;
            ArrayList<PropertyValue> targetProperties = new ArrayList<PropertyValue>();
            LatLng latLng = GeoRepositoryStrategy.getLatLngFromCentreonWeb(relation);
            if (latLng != null && latLng != LatLng.CENTER) {
                relation.addPropertyValue(ElementPropertyDescriptors.LATLNG, (Object)latLng);
            } else {
                ListOfPos points;
                Pos pos = (Pos)relation.getProperty(PropertyDescriptors.CURRENT_POSITION);
                relation.addPropertyValue(ElementPropertyDescriptors.LATLNG, (Object)GeoRepositoryStrategy.computeLatLng(relation.getSource(), pos));
                ListOfPos bendpoints = (ListOfPos)relation.getTarget().getProperty(PropertyDescriptors.BENDPOINTS);
                if (!bendpoints.isEmpty()) {
                    ListOfLatLng bendlatlongs = new ListOfLatLng(bendpoints.size());
                    for (Pos bendpoint : bendpoints) {
                        bendlatlongs.add((Object)GeoRepositoryStrategy.computeLatLng(relation.getSource(), bendpoint));
                    }
                    targetProperties.add(new PropertyValue(GeoPropertyDescriptors.BENDLATLNGS, (Object)bendlatlongs));
                }
                if (!(points = (ListOfPos)relation.getTarget().getProperty(PropertyDescriptors.POINTS)).isEmpty()) {
                    Pos origin = pos.minus(((Pos)relation.getProperty(PropertyDescriptors.CURRENT_DIMENSION)).div(2.0));
                    ListOfLatLng latlongs = new ListOfLatLng(points.size());
                    for (Pos point : points) {
                        Pos absolutePoint = point.plus(origin);
                        latlongs.add((Object)GeoRepositoryStrategy.computeLatLng(relation.getSource(), absolutePoint));
                    }
                    targetProperties.add(new PropertyValue(GeoPropertyDescriptors.LATLNGS, (Object)latlongs));
                }
            }
            targetProperties.add(new PropertyValue(PropertyDescriptors.ZOOM, (Object)((Double)relation.getSource().getProperty(PropertyDescriptors.CURRENT_ZOOM))));
            relation.getTarget().addPropertyValues(targetProperties);
        }
    }

    public void propertiesChanged(ObjectDecorator decorator, Collection<PropertyValue> propertyValues) {
        if (decorator instanceof NodeDecorator) {
            GeoRepositoryStrategy.propertiesChanged((INode)decorator, propertyValues);
        } else if (decorator instanceof RelationDecorator) {
            GeoRepositoryStrategy.propertiesChanged((INodeRelation)decorator, propertyValues);
        }
    }

    public void relationsAdded(NodeDecorator decorator, Collection<INodeRelation> relations) {
        if (decorator instanceof IRepository) {
            for (INodeRelation relation : relations) {
                LatLng latlng = (LatLng)relation.getTarget().getProperty(ElementPropertyDescriptors.LATLNG);
                LatLng currentLatlng = (LatLng)relation.getTarget().getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
                ((INodeRelation)relation.adapt(INodeRelation.class)).addPropertyValues(Arrays.asList(new PropertyValue(ElementPropertyDescriptors.LATLNG, (Object)latlng), new PropertyValue(GeoPropertyDescriptors.CURRENT_LATLNG, (Object)currentLatlng)));
            }
        }
        for (INodeRelation relation : relations) {
            if (!((Boolean)relation.getSource().getProperty(GeoPropertyDescriptors.IS_GEO)).booleanValue()) continue;
            LatLng latLng = (LatLng)relation.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
            Double parentZoom = (Double)relation.getSource().getProperty(PropertyDescriptors.CURRENT_ZOOM);
            LatLng parentLatLng = (LatLng)relation.getSource().getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
            Pos pos = MapBoxProvider.latLngToPoint(latLng, parentZoom.intValue(), parentLatLng);
            ((INodeRelation)relation.adapt(INodeRelation.class)).addPropertyValue(PropertyDescriptors.CURRENT_POSITION, (Object)pos);
            ListOfLatLng bendLatLngs = (ListOfLatLng)relation.getTarget().getProperty(GeoPropertyDescriptors.BENDLATLNGS);
            if (bendLatLngs.isEmpty()) continue;
            ListOfPos bendpoints = new ListOfPos(bendLatLngs.size());
            for (LatLng bendLatLng : bendLatLngs) {
                bendpoints.add((Object)MapBoxProvider.latLngToPoint(bendLatLng, parentZoom.intValue(), parentLatLng));
            }
            ((INodeRelation)relation.adapt(INodeRelation.class)).getTarget().addPropertyValue(PropertyDescriptors.BENDPOINTS, (Object)bendpoints);
        }
    }

    public void selectionChanged(RepositoryDecorator decorator, Object source) {
        INodeRelation parentRelation;
        INodeRelation selection;
        if (decorator.getSelections().size() == 1 && !(source instanceof GraphicalViewer) && ((Boolean)(selection = decorator.getSelection()).getSource().getProperty(GeoPropertyDescriptors.IS_GEO)).booleanValue() && (parentRelation = INodeUtils.findRelationForTarget((INode)selection.getRepository(), (TypeDescriptor)selection.getSource().getType(), (Long)selection.getSource().getId(), (PropertyValue[])new PropertyValue[0])) != null) {
            LatLng latLng = (LatLng)selection.getProperty(GeoPropertyDescriptors.CURRENT_LATLNG);
            parentRelation.addPropertyValue(GeoPropertyDescriptors.CURRENT_LATLNG, (Object)latLng);
        }
    }
}

